/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.util;

import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.transformation.datastructure.util.ValueRecorder;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.FloatColumn;
import org.apache.tsfile.read.common.block.column.IntColumn;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class TransformUtils {
    private TransformUtils() {
        throw new IllegalStateException("TransformUtils should not be instantiated.");
    }

    public static int compare(Binary first, Binary second) {
        if (Objects.requireNonNull(first) == Objects.requireNonNull(second)) {
            return 0;
        }
        return first.compareTo(second);
    }

    public static Column transformConstantOperandToColumn(ConstantOperand constantOperand) {
        Objects.requireNonNull(constantOperand);
        try {
            Object value = CommonUtils.parseValue(constantOperand.getDataType(), constantOperand.getValueString());
            if (value == null) {
                throw new UnsupportedOperationException("Invalid constant operand: " + constantOperand.getExpressionString());
            }
            switch (constantOperand.getDataType()) {
                case INT32: {
                    return new IntColumn(1, Optional.empty(), new int[]{(Integer)value});
                }
                case INT64: {
                    return new LongColumn(1, Optional.empty(), new long[]{(Long)value});
                }
                case FLOAT: {
                    return new FloatColumn(1, Optional.empty(), new float[]{((Float)value).floatValue()});
                }
                case DOUBLE: {
                    return new DoubleColumn(1, Optional.empty(), new double[]{(Double)value});
                }
                case TEXT: {
                    return new BinaryColumn(1, Optional.empty(), new Binary[]{(Binary)value});
                }
                case BOOLEAN: {
                    return new BooleanColumn(1, Optional.empty(), new boolean[]{(Boolean)value});
                }
            }
            throw new UnSupportedDataTypeException("Unsupported type: " + constantOperand.getDataType());
        }
        catch (QueryProcessException e) {
            throw new UnsupportedOperationException((Throwable)((Object)e));
        }
    }

    public static boolean splitWindowForStateWindow(TSDataType dataType, ValueRecorder valueRecorder, double delta, Column values, int index) {
        boolean res;
        switch (dataType) {
            case INT32: {
                if (!valueRecorder.hasRecorded()) {
                    valueRecorder.recordInt(values.getInt(index - 1));
                    valueRecorder.setRecorded(true);
                }
                boolean bl = res = (double)Math.abs(values.getInt(index) - valueRecorder.getInt()) > delta;
                if (!res) break;
                valueRecorder.recordInt(values.getInt(index));
                break;
            }
            case INT64: {
                if (!valueRecorder.hasRecorded()) {
                    valueRecorder.recordLong(values.getLong(index - 1));
                    valueRecorder.setRecorded(true);
                }
                boolean bl = res = (double)Math.abs(values.getLong(index) - valueRecorder.getLong()) > delta;
                if (!res) break;
                valueRecorder.recordLong(values.getLong(index));
                break;
            }
            case FLOAT: {
                if (!valueRecorder.hasRecorded()) {
                    valueRecorder.recordFloat(values.getFloat(index - 1));
                    valueRecorder.setRecorded(true);
                }
                boolean bl = res = (double)Math.abs(values.getFloat(index) - valueRecorder.getFloat()) > delta;
                if (!res) break;
                valueRecorder.recordFloat(values.getFloat(index));
                break;
            }
            case DOUBLE: {
                if (!valueRecorder.hasRecorded()) {
                    valueRecorder.recordDouble(values.getDouble(index - 1));
                    valueRecorder.setRecorded(true);
                }
                boolean bl = res = Math.abs(values.getDouble(index) - valueRecorder.getDouble()) > delta;
                if (!res) break;
                valueRecorder.recordDouble(values.getDouble(index));
                break;
            }
            case BOOLEAN: {
                if (!valueRecorder.hasRecorded()) {
                    valueRecorder.recordBoolean(values.getBoolean(index - 1));
                    valueRecorder.setRecorded(true);
                }
                boolean bl = res = values.getBoolean(index) != valueRecorder.getBoolean();
                if (!res) break;
                valueRecorder.recordBoolean(values.getBoolean(index));
                break;
            }
            case TEXT: {
                String str;
                if (!valueRecorder.hasRecorded()) {
                    Binary binary = values.getBinary(index - 1);
                    valueRecorder.recordString(binary.toString());
                    valueRecorder.setRecorded(true);
                }
                boolean bl = res = !(str = values.getBinary(index).toString()).equals(valueRecorder.getString());
                if (!res) break;
                valueRecorder.recordString(str);
                break;
            }
            default: {
                throw new UnsupportedOperationException("The data type of the state window strategy is not valid.");
            }
        }
        return res;
    }
}

