/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.configuration;

import org.apache.iotdb.db.utils.windowing.configuration.Configuration;
import org.apache.iotdb.db.utils.windowing.exception.WindowingException;
import org.apache.tsfile.enums.TSDataType;

public class SlidingTimeWindowConfiguration
extends Configuration {
    private final long timeInterval;
    private final long slidingStep;

    public SlidingTimeWindowConfiguration(TSDataType dataType, long timeInterval, long slidingStep) {
        super(dataType);
        this.timeInterval = timeInterval;
        this.slidingStep = slidingStep;
    }

    public SlidingTimeWindowConfiguration(TSDataType dataType, long timeInterval) {
        super(dataType);
        this.timeInterval = timeInterval;
        this.slidingStep = timeInterval;
    }

    @Override
    public void check() throws WindowingException {
        if (this.timeInterval <= 0L) {
            throw new WindowingException(String.format("Parameter timeInterval(%d) should be positive.", this.timeInterval));
        }
        if (this.slidingStep <= 0L) {
            throw new WindowingException(String.format("Parameter slidingStep(%d) should be positive.", this.slidingStep));
        }
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getSlidingStep() {
        return this.slidingStep;
    }
}

