/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.ConfigPhysicalReadPlan;
import org.apache.iotdb.confignode.rpc.thrift.TGetModelInfoReq;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class GetModelInfoPlan
extends ConfigPhysicalReadPlan {
    private String modelId;

    public GetModelInfoPlan() {
        super(ConfigPhysicalPlanType.GetModelInfo);
    }

    public GetModelInfoPlan(TGetModelInfoReq getModelInfoReq) {
        super(ConfigPhysicalPlanType.GetModelInfo);
        this.modelId = getModelInfoReq.getModelId();
    }

    public String getModelId() {
        return this.modelId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.modelId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GetModelInfoPlan that = (GetModelInfoPlan)o;
        return Objects.equals(this.modelId, that.modelId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelId);
    }
}

