/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class PipeHandleMetaChangePlan
extends ConfigPhysicalPlan {
    private List<PipeMeta> pipeMetaList = new ArrayList<PipeMeta>();

    public PipeHandleMetaChangePlan() {
        super(ConfigPhysicalPlanType.PipeHandleMetaChange);
    }

    public PipeHandleMetaChangePlan(List<PipeMeta> pipeMetaList) {
        super(ConfigPhysicalPlanType.PipeHandleMetaChange);
        this.pipeMetaList = pipeMetaList;
    }

    public List<PipeMeta> getPipeMetaList() {
        return this.pipeMetaList;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.pipeMetaList.size());
        for (PipeMeta pipeMeta : this.pipeMetaList) {
            pipeMeta.serialize((OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            PipeMeta pipeMeta = PipeMeta.deserialize4Coordinator((ByteBuffer)buffer);
            this.pipeMetaList.add(pipeMeta);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeHandleMetaChangePlan that = (PipeHandleMetaChangePlan)obj;
        return Objects.equals(this.pipeMetaList, that.pipeMetaList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pipeMetaList);
    }
}

