/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.iot.logdispatcher.Batch;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManagerMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensusMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(IoTConsensusMemoryManager.class);
    private final AtomicLong memorySizeInByte = new AtomicLong(0L);
    private final AtomicLong queueMemorySizeInByte = new AtomicLong(0L);
    private final AtomicLong syncMemorySizeInByte = new AtomicLong(0L);
    private Long maxMemorySizeInByte = Runtime.getRuntime().maxMemory() / 10L;
    private Long maxMemorySizeForQueueInByte = Runtime.getRuntime().maxMemory() / 100L * 6L;
    private static final IoTConsensusMemoryManager INSTANCE = new IoTConsensusMemoryManager();

    private IoTConsensusMemoryManager() {
        MetricService.getInstance().addMetricSet((IMetricSet)new IoTConsensusMemoryManagerMetrics(this));
    }

    public boolean reserve(IndexedConsensusRequest request) {
        long prevRef = request.incRef();
        if (prevRef == 0L) {
            boolean reserved = this.reserve(request.getMemorySize(), true);
            if (reserved) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Reserving {} bytes for request {} succeeds, current total usage {}", new Object[]{request.getMemorySize(), request.getSearchIndex(), this.memorySizeInByte.get()});
                }
            } else {
                request.decRef();
                if (logger.isDebugEnabled()) {
                    logger.debug("Reserving {} bytes for request {} fails, current total usage {}", new Object[]{request.getMemorySize(), request.getSearchIndex(), this.memorySizeInByte.get()});
                }
            }
            return reserved;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Skip memory reservation for {} because its ref count is not 0", (Object)request.getSearchIndex());
        }
        return true;
    }

    public boolean reserve(Batch batch) {
        boolean reserved = this.reserve(batch.getMemorySize(), false);
        if (reserved && logger.isDebugEnabled()) {
            logger.debug("Reserving {} bytes for batch {}-{} succeeds, current total usage {}", new Object[]{batch.getMemorySize(), batch.getStartIndex(), batch.getEndIndex(), this.memorySizeInByte.get()});
        } else if (logger.isDebugEnabled()) {
            logger.debug("Reserving {} bytes for batch {}-{} fails, current total usage {}", new Object[]{batch.getMemorySize(), batch.getStartIndex(), batch.getEndIndex(), this.memorySizeInByte.get()});
        }
        return reserved;
    }

    private boolean reserve(long size, boolean fromQueue) {
        boolean result;
        boolean bl = result = this.memorySizeInByte.addAndGet(size) < this.maxMemorySizeInByte;
        if (result) {
            if (fromQueue) {
                boolean bl2 = result = this.queueMemorySizeInByte.addAndGet(size) < this.maxMemorySizeForQueueInByte;
                if (!result) {
                    this.queueMemorySizeInByte.addAndGet(-size);
                }
            } else {
                this.syncMemorySizeInByte.addAndGet(size);
            }
        } else {
            this.memorySizeInByte.addAndGet(-size);
        }
        return result;
    }

    public void free(IndexedConsensusRequest request) {
        long prevRef = request.decRef();
        if (prevRef == 1L) {
            this.free(request.getMemorySize(), true);
            if (logger.isDebugEnabled()) {
                logger.debug("Freed {} bytes for request {}, current total usage {}", new Object[]{request.getMemorySize(), request.getSearchIndex(), this.memorySizeInByte.get()});
            }
        }
    }

    public void free(Batch batch) {
        this.free(batch.getMemorySize(), false);
        if (logger.isDebugEnabled()) {
            logger.debug("Freed {} bytes for batch {}-{}, current total usage {}", new Object[]{batch.getMemorySize(), batch.getStartIndex(), batch.getEndIndex(), this.getMemorySizeInByte()});
        }
    }

    private void free(long size, boolean fromQueue) {
        long currentUsedMemory = this.memorySizeInByte.addAndGet(-size);
        if (fromQueue) {
            this.queueMemorySizeInByte.addAndGet(-size);
        } else {
            this.syncMemorySizeInByte.addAndGet(-size);
        }
        logger.debug("{} free {} bytes, total memory size: {} bytes.", new Object[]{Thread.currentThread().getName(), size, currentUsedMemory});
    }

    public void init(long maxMemorySize, long maxMemorySizeForQueue) {
        this.maxMemorySizeInByte = maxMemorySize;
        this.maxMemorySizeForQueueInByte = maxMemorySizeForQueue;
    }

    public void reset() {
        this.memorySizeInByte.set(0L);
        this.queueMemorySizeInByte.set(0L);
        this.syncMemorySizeInByte.set(0L);
    }

    long getMemorySizeInByte() {
        return this.memorySizeInByte.get();
    }

    long getQueueMemorySizeInByte() {
        return this.queueMemorySizeInByte.get();
    }

    long getSyncMemorySizeInByte() {
        return this.syncMemorySizeInByte.get();
    }

    public static IoTConsensusMemoryManager getInstance() {
        return INSTANCE;
    }
}

