/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.function.arithmetic;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tsfile.read.common.type.DateType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.UnknownType;

public class AdditionResolver {
    private static final Map<Type, Map<Type, Type>> CONDITION_MAP = new HashMap<Type, Map<Type, Type>>();

    private static void addCondition(Type condition1, Type condition2, Type result) {
        CONDITION_MAP.computeIfAbsent(condition1, k -> new HashMap()).put(condition2, result);
    }

    public static Optional<Type> checkConditions(List<? extends Type> argumentTypes) {
        return Optional.ofNullable(CONDITION_MAP.getOrDefault(argumentTypes.get(0), Collections.emptyMap()).getOrDefault(argumentTypes.get(1), null));
    }

    static {
        AdditionResolver.addCondition((Type)IntType.INT32, (Type)IntType.INT32, (Type)IntType.INT32);
        AdditionResolver.addCondition((Type)IntType.INT32, (Type)LongType.INT64, (Type)LongType.INT64);
        AdditionResolver.addCondition((Type)IntType.INT32, (Type)FloatType.FLOAT, (Type)FloatType.FLOAT);
        AdditionResolver.addCondition((Type)IntType.INT32, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)IntType.INT32, (Type)DateType.DATE, (Type)DateType.DATE);
        AdditionResolver.addCondition((Type)IntType.INT32, (Type)TimestampType.TIMESTAMP, (Type)TimestampType.TIMESTAMP);
        AdditionResolver.addCondition((Type)IntType.INT32, (Type)UnknownType.UNKNOWN, (Type)IntType.INT32);
        AdditionResolver.addCondition((Type)LongType.INT64, (Type)IntType.INT32, (Type)LongType.INT64);
        AdditionResolver.addCondition((Type)LongType.INT64, (Type)LongType.INT64, (Type)LongType.INT64);
        AdditionResolver.addCondition((Type)LongType.INT64, (Type)FloatType.FLOAT, (Type)FloatType.FLOAT);
        AdditionResolver.addCondition((Type)LongType.INT64, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)LongType.INT64, (Type)DateType.DATE, (Type)DateType.DATE);
        AdditionResolver.addCondition((Type)LongType.INT64, (Type)TimestampType.TIMESTAMP, (Type)TimestampType.TIMESTAMP);
        AdditionResolver.addCondition((Type)LongType.INT64, (Type)UnknownType.UNKNOWN, (Type)LongType.INT64);
        AdditionResolver.addCondition((Type)FloatType.FLOAT, (Type)IntType.INT32, (Type)FloatType.FLOAT);
        AdditionResolver.addCondition((Type)FloatType.FLOAT, (Type)LongType.INT64, (Type)FloatType.FLOAT);
        AdditionResolver.addCondition((Type)FloatType.FLOAT, (Type)FloatType.FLOAT, (Type)FloatType.FLOAT);
        AdditionResolver.addCondition((Type)FloatType.FLOAT, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)FloatType.FLOAT, (Type)UnknownType.UNKNOWN, (Type)FloatType.FLOAT);
        AdditionResolver.addCondition((Type)DoubleType.DOUBLE, (Type)IntType.INT32, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)DoubleType.DOUBLE, (Type)LongType.INT64, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)DoubleType.DOUBLE, (Type)FloatType.FLOAT, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)DoubleType.DOUBLE, (Type)UnknownType.UNKNOWN, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)DateType.DATE, (Type)IntType.INT32, (Type)DateType.DATE);
        AdditionResolver.addCondition((Type)DateType.DATE, (Type)LongType.INT64, (Type)DateType.DATE);
        AdditionResolver.addCondition((Type)DateType.DATE, (Type)UnknownType.UNKNOWN, (Type)DateType.DATE);
        AdditionResolver.addCondition((Type)TimestampType.TIMESTAMP, (Type)IntType.INT32, (Type)TimestampType.TIMESTAMP);
        AdditionResolver.addCondition((Type)TimestampType.TIMESTAMP, (Type)LongType.INT64, (Type)TimestampType.TIMESTAMP);
        AdditionResolver.addCondition((Type)TimestampType.TIMESTAMP, (Type)UnknownType.UNKNOWN, (Type)TimestampType.TIMESTAMP);
        AdditionResolver.addCondition((Type)UnknownType.UNKNOWN, (Type)IntType.INT32, (Type)IntType.INT32);
        AdditionResolver.addCondition((Type)UnknownType.UNKNOWN, (Type)LongType.INT64, (Type)LongType.INT64);
        AdditionResolver.addCondition((Type)UnknownType.UNKNOWN, (Type)FloatType.FLOAT, (Type)FloatType.FLOAT);
        AdditionResolver.addCondition((Type)UnknownType.UNKNOWN, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
        AdditionResolver.addCondition((Type)UnknownType.UNKNOWN, (Type)DateType.DATE, (Type)DateType.DATE);
        AdditionResolver.addCondition((Type)UnknownType.UNKNOWN, (Type)TimestampType.TIMESTAMP, (Type)TimestampType.TIMESTAMP);
    }
}

