/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.AuthenticationMessage;
import io.r2dbc.postgresql.message.backend.BackendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AuthenticationSASL
implements AuthenticationMessage {
    private static final byte TERMINAL = 0;
    private final List<String> authenticationMechanisms;

    public AuthenticationSASL(List<String> authenticationMechanisms) {
        this.authenticationMechanisms = Assert.requireNonNull(authenticationMechanisms, "authenticationMechanisms must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationSASL that = (AuthenticationSASL)o;
        return Objects.equals(this.authenticationMechanisms, that.authenticationMechanisms);
    }

    public List<String> getAuthenticationMechanisms() {
        return this.authenticationMechanisms;
    }

    public int hashCode() {
        return Objects.hash(this.authenticationMechanisms);
    }

    public String toString() {
        return "AuthenticationSASL{authenticationMechanisms=" + this.authenticationMechanisms + '}';
    }

    static AuthenticationSASL decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        ArrayList<String> authenticationMechanisms = new ArrayList<String>();
        while (0 != in.getByte(in.readerIndex())) {
            authenticationMechanisms.add(BackendMessageUtils.readCStringUTF8(in));
        }
        return new AuthenticationSASL(authenticationMechanisms);
    }
}

