/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import jakarta.inject.Inject;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.routes.Applicable;
import org.apache.james.jmap.routes.AttachmentBlob;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobResolutionResult;
import org.apache.james.jmap.routes.BlobResolver;
import org.apache.james.jmap.routes.NonApplicable$;
import org.apache.james.mailbox.AttachmentIdFactory;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005a3Aa\u0002\u0005\u0001'!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003!\u0011!9\u0003A!b\u0001\n\u0003A\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u000b5\u0002A\u0011\u0001\u0018\t\u000bm\u0002A\u0011\t\u001f\u0003-\u0005#H/Y2i[\u0016tGO\u00117pEJ+7o\u001c7wKJT!!\u0003\u0006\u0002\rI|W\u000f^3t\u0015\tYA\"\u0001\u0003k[\u0006\u0004(BA\u0007\u000f\u0003\u0015Q\u0017-\\3t\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0006\u000e\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tYB$D\u0001\t\u0013\ti\u0002B\u0001\u0007CY>\u0014'+Z:pYZ,'/A\tbiR\f7\r[7f]Rl\u0015M\\1hKJ,\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003G1\tq!\\1jY\n|\u00070\u0003\u0002&E\t\t\u0012\t\u001e;bG\"lWM\u001c;NC:\fw-\u001a:\u0002%\u0005$H/Y2i[\u0016tG/T1oC\u001e,'\u000fI\u0001\u0014CR$\u0018m\u00195nK:$\u0018\n\u001a$bGR|'/_\u000b\u0002SA\u0011\u0011EK\u0005\u0003W\t\u00121#\u0011;uC\u000eDW.\u001a8u\u0013\u00124\u0015m\u0019;pef\fA#\u0019;uC\u000eDW.\u001a8u\u0013\u00124\u0015m\u0019;pef\u0004\u0013A\u0002\u001fj]&$h\bF\u00020aE\u0002\"a\u0007\u0001\t\u000by)\u0001\u0019\u0001\u0011\t\u000b\u001d*\u0001\u0019A\u0015)\u0005\u0015\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0019IgN[3di*\t\u0001(A\u0004kC.\f'\u000f^1\n\u0005i*$AB%oU\u0016\u001cG/A\u0004sKN|GN^3\u0015\u0007uZ5\u000bE\u0002?\r\"k\u0011a\u0010\u0006\u0003\u0001\u0006\u000b\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0005]\u0011%BA\"E\u0003\u0011\u0019wN]3\u000b\u0003\u0015\u000bqA]3bGR|'/\u0003\u0002H\u007f\t)1+T8o_B\u00111$S\u0005\u0003\u0015\"\u0011AC\u00117pEJ+7o\u001c7vi&|gNU3tk2$\b\"\u0002'\u0007\u0001\u0004i\u0015A\u00022m_\nLE\r\u0005\u0002O#6\tqJ\u0003\u0002Q\u0015\u0005!Q.Y5m\u0013\t\u0011vJ\u0001\u0004CY>\u0014\u0017\n\u001a\u0005\u0006)\u001a\u0001\r!V\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\t\tc+\u0003\u0002XE\tqQ*Y5mE>D8+Z:tS>t\u0007")
public class AttachmentBlobResolver
implements BlobResolver {
    private final AttachmentManager attachmentManager;
    private final AttachmentIdFactory attachmentIdFactory;

    public AttachmentManager attachmentManager() {
        return this.attachmentManager;
    }

    public AttachmentIdFactory attachmentIdFactory() {
        return this.attachmentIdFactory;
    }

    public SMono<BlobResolutionResult> resolve(BlobId blobId, MailboxSession mailboxSession) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.attachmentIdFactory().from(blobId.value()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AttachmentId attachmentId = (AttachmentId)success.value();
            return SMono$.MODULE$.apply((Publisher)this.attachmentManager().getAttachmentReactive(attachmentId, mailboxSession)).map((Function1 & Serializable)attachmentMetadata -> new Applicable((SMono<Blob>)SMono$.MODULE$.apply((Publisher)this.attachmentManager().loadReactive(attachmentMetadata, mailboxSession)).map((Function1 & Serializable)content -> new AttachmentBlob((AttachmentMetadata)attachmentMetadata, (InputStream)content)))).onErrorResume((Function1 & Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                if (throwable instanceof AttachmentNotFoundException) {
                    return SMono$.MODULE$.just((Object)NonApplicable$.MODULE$);
                }
                return SMono$.MODULE$.error(throwable);
            });
        }
        return SMono$.MODULE$.just((Object)NonApplicable$.MODULE$);
    }

    @Inject
    public AttachmentBlobResolver(AttachmentManager attachmentManager, AttachmentIdFactory attachmentIdFactory) {
        this.attachmentManager = attachmentManager;
        this.attachmentIdFactory = attachmentIdFactory;
    }
}

