/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import reactor.core.publisher.Mono;

public class ContentTypeFilteringTextExtractor
implements TextExtractor {
    private final TextExtractor textExtractor;
    private final ImmutableSet<ContentType.MimeType> contentTypeBlacklist;

    public ContentTypeFilteringTextExtractor(TextExtractor textExtractor, ImmutableSet<ContentType.MimeType> contentTypeBlacklist) {
        this.textExtractor = textExtractor;
        this.contentTypeBlacklist = contentTypeBlacklist;
    }

    public boolean applicable(ContentType contentType) {
        return !this.isBlacklisted(contentType.mimeType());
    }

    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) throws Exception {
        if (this.isBlacklisted(contentType.mimeType())) {
            return ParsedContent.empty();
        }
        return this.textExtractor.extractContent(inputStream, contentType);
    }

    public Mono<ParsedContent> extractContentReactive(InputStream inputStream, ContentType contentType) {
        if (this.isBlacklisted(contentType.mimeType())) {
            return Mono.just((Object)ParsedContent.empty());
        }
        return this.textExtractor.extractContentReactive(inputStream, contentType);
    }

    private boolean isBlacklisted(ContentType.MimeType contentType) {
        return this.contentTypeBlacklist.contains((Object)contentType);
    }
}

