/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class WildcardQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final Boolean caseInsensitive;
    @Nullable
    private final String rewrite;
    @Nullable
    private final String value;
    @Nullable
    private final String wildcard;
    public static final JsonpDeserializer<WildcardQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WildcardQuery::setupWildcardQueryDeserializer);

    private WildcardQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.caseInsensitive = builder.caseInsensitive;
        this.rewrite = builder.rewrite;
        this.value = builder.value;
        this.wildcard = builder.wildcard;
    }

    public static WildcardQuery of(Function<Builder, ObjectBuilder<WildcardQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Wildcard;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Nullable
    public final String rewrite() {
        return this.rewrite;
    }

    @Nullable
    public final String value() {
        return this.value;
    }

    @Nullable
    public final String wildcard() {
        return this.wildcard;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value);
        }
        if (this.wildcard != null) {
            generator.writeKey("wildcard");
            generator.write(this.wildcard);
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).field(this.field).value(this.value).caseInsensitive(this.caseInsensitive).rewrite(this.rewrite).value(this.value).wildcard(this.wildcard);
    }

    protected static void setupWildcardQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite");
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
        op.add(Builder::wildcard, JsonpDeserializer.stringDeserializer(), "wildcard");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WildcardQuery> {
        private String field;
        @Nullable
        private Boolean caseInsensitive;
        @Nullable
        private String rewrite;
        @Nullable
        private String value;
        @Nullable
        private String wildcard;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public final Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public final Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder wildcard(@Nullable String value) {
            this.wildcard = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WildcardQuery build() {
            this._checkSingleUse();
            return new WildcardQuery(this);
        }
    }
}

