/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;

public class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> unique(List<T> list) {
        return list.stream().distinct().toList();
    }

    public static List<Integer> asList(int ... values) {
        ArrayList<Integer> x = new ArrayList<Integer>(values.length);
        for (int v : values) {
            x.add(v);
        }
        return x;
    }

    public static <T> T last(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Deprecated(forRemoval=true)
    public static <T> List<T> toList(Stream<T> stream) {
        return stream.toList();
    }

    public static <T> String str(T[] array) {
        return Arrays.stream(array).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String str(int[] array) {
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String str(long[] array) {
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    public static <T> void print(IndentedWriter out, List<T> list) {
        ListUtils.print(out, list, " ");
    }

    public static <T> void print(IndentedWriter out, List<T> list, CharSequence sep) {
        out.print(list.stream().map(String::valueOf).collect(Collectors.joining(sep)));
    }

    public static <T> boolean equalsUnordered(List<T> list1, List<T> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        ArrayList<T> list2a = new ArrayList<T>(list2);
        for (T elt : list1) {
            list2a.remove(elt);
        }
        return list2a.isEmpty();
    }

    public static <T> List<T> listDiff(List<T> list1, List<T> list2) {
        Pair<List<T>, List<T>> x = ListUtils.listDiffBoth(list1, list2);
        return x.getLeft();
    }

    public static <T> Pair<List<T>, List<T>> listDiffBoth(List<T> list1, List<T> list2) {
        ArrayList<T> results = new ArrayList<T>();
        ArrayList<T> list2copy = new ArrayList<T>(list2);
        for (T elt : list1) {
            if (list2copy.contains(elt)) {
                list2copy.remove(elt);
                continue;
            }
            results.add(elt);
        }
        return Pair.create(results, list2copy);
    }

    public static <T> List<List<T>> permute(List<T> c) {
        if (c.size() > 5) {
            Log.warn(ListUtils.class, "Attempt to permute more than 5 items - think again");
            return null;
        }
        ArrayList<List<T>> x = new ArrayList<List<T>>();
        if (c.size() == 1) {
            x.add(c);
            return x;
        }
        for (T obj : c) {
            ArrayList<T> c2 = new ArrayList<T>(c);
            c2.remove(obj);
            List<List<T>> x2 = ListUtils.permute(c2);
            for (List<T> x3 : x2) {
                x3.add(0, obj);
                x.add(x3);
            }
        }
        return x;
    }
}

