/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.store.roaring;

import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.IndexingStrategy;
import org.apache.jena.mem2.pattern.MatchPattern;
import org.apache.jena.mem2.pattern.PatternClassifier;
import org.apache.jena.mem2.store.TripleStore;
import org.apache.jena.mem2.store.roaring.TripleSet;
import org.apache.jena.mem2.store.roaring.strategies.EagerStoreStrategy;
import org.apache.jena.mem2.store.roaring.strategies.LazyStoreStrategy;
import org.apache.jena.mem2.store.roaring.strategies.ManualStoreStrategy;
import org.apache.jena.mem2.store.roaring.strategies.MinimalStoreStrategy;
import org.apache.jena.mem2.store.roaring.strategies.StoreStrategy;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.SingletonIterator;

public class RoaringTripleStore
implements TripleStore {
    private static final String UNKNOWN_PATTERN_CLASSIFIER = "Unknown pattern classifier: %s";
    final TripleSet triples;
    private StoreStrategy currentStrategy;
    private final IndexingStrategy indexingStrategy;

    public RoaringTripleStore() {
        this(IndexingStrategy.EAGER);
    }

    public RoaringTripleStore(IndexingStrategy indexingStrategy) {
        this.triples = new TripleSet();
        this.indexingStrategy = indexingStrategy;
        this.currentStrategy = this.createStoreStrategy(indexingStrategy);
    }

    private RoaringTripleStore(RoaringTripleStore storeToCopy) {
        this.triples = storeToCopy.triples.copy();
        this.indexingStrategy = storeToCopy.indexingStrategy;
        StoreStrategy storeStrategy = storeToCopy.currentStrategy;
        if (storeStrategy instanceof EagerStoreStrategy) {
            EagerStoreStrategy eagerStoreStrategy = (EagerStoreStrategy)storeStrategy;
            this.currentStrategy = new EagerStoreStrategy(this.triples, eagerStoreStrategy);
        } else {
            this.currentStrategy = this.createStoreStrategy(this.indexingStrategy);
        }
    }

    private StoreStrategy createStoreStrategy(IndexingStrategy indexingStrategy) {
        return switch (indexingStrategy) {
            case IndexingStrategy.EAGER -> new EagerStoreStrategy(this.triples);
            case IndexingStrategy.LAZY -> new LazyStoreStrategy(this::setCurrentStrategyToNewEagerStoreStrategy);
            case IndexingStrategy.LAZY_PARALLEL -> new LazyStoreStrategy(this::setCurrentStrategyToNewEagerStoreStrategyParallel);
            case IndexingStrategy.MANUAL -> new ManualStoreStrategy();
            case IndexingStrategy.MINIMAL -> new MinimalStoreStrategy(this.triples);
            default -> throw new IllegalArgumentException("Unknown indexing strategy: " + String.valueOf((Object)indexingStrategy));
        };
    }

    private EagerStoreStrategy setCurrentStrategyToNewEagerStoreStrategy() {
        EagerStoreStrategy eagerStoreStrategy = new EagerStoreStrategy(this.triples, false);
        this.currentStrategy = eagerStoreStrategy;
        return eagerStoreStrategy;
    }

    private EagerStoreStrategy setCurrentStrategyToNewEagerStoreStrategyParallel() {
        EagerStoreStrategy eagerStoreStrategy = new EagerStoreStrategy(this.triples, true);
        this.currentStrategy = eagerStoreStrategy;
        return eagerStoreStrategy;
    }

    public boolean isIndexInitialized() {
        return this.currentStrategy instanceof EagerStoreStrategy;
    }

    public IndexingStrategy getIndexingStrategy() {
        return this.indexingStrategy;
    }

    public void clearIndex() {
        this.currentStrategy = this.createStoreStrategy(this.indexingStrategy);
    }

    public void initializeIndex() {
        this.currentStrategy = new EagerStoreStrategy(this.triples, false);
    }

    public void initializeIndexParallel() {
        this.currentStrategy = new EagerStoreStrategy(this.triples, true);
    }

    @Override
    public void add(Triple triple) {
        int index = this.triples.addAndGetIndex(triple);
        if (index < 0) {
            return;
        }
        this.currentStrategy.addToIndex(triple, index);
    }

    @Override
    public void remove(Triple triple) {
        int index = this.triples.removeAndGetIndex(triple);
        if (index < 0) {
            return;
        }
        this.currentStrategy.removeFromIndex(triple, index);
    }

    @Override
    public void clear() {
        this.triples.clear();
        this.currentStrategy.clearIndex();
    }

    @Override
    public int countTriples() {
        return this.triples.size();
    }

    @Override
    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    @Override
    public boolean contains(Triple tripleMatch) {
        MatchPattern matchPattern = PatternClassifier.classify(tripleMatch);
        switch (matchPattern) {
            case SUB_ANY_ANY: 
            case ANY_PRE_ANY: 
            case ANY_ANY_OBJ: 
            case SUB_PRE_ANY: 
            case ANY_PRE_OBJ: 
            case SUB_ANY_OBJ: {
                return this.currentStrategy.containsMatch(tripleMatch, matchPattern);
            }
            case SUB_PRE_OBJ: {
                return this.triples.containsKey(tripleMatch);
            }
            case ANY_ANY_ANY: {
                return !this.isEmpty();
            }
        }
        throw new IllegalStateException(String.format(UNKNOWN_PATTERN_CLASSIFIER, new Object[]{PatternClassifier.classify(tripleMatch)}));
    }

    @Override
    public Stream<Triple> stream() {
        return this.triples.keyStream();
    }

    @Override
    public Stream<Triple> stream(Triple tripleMatch) {
        MatchPattern pattern = PatternClassifier.classify(tripleMatch);
        switch (pattern) {
            case SUB_PRE_OBJ: {
                return this.triples.containsKey(tripleMatch) ? Stream.of(tripleMatch) : Stream.empty();
            }
            case SUB_ANY_ANY: 
            case ANY_PRE_ANY: 
            case ANY_ANY_OBJ: 
            case SUB_PRE_ANY: 
            case ANY_PRE_OBJ: 
            case SUB_ANY_OBJ: {
                return this.currentStrategy.streamMatch(tripleMatch, pattern);
            }
            case ANY_ANY_ANY: {
                return this.stream();
            }
        }
        throw new IllegalStateException("Unknown pattern classifier: " + String.valueOf((Object)PatternClassifier.classify(tripleMatch)));
    }

    @Override
    public ExtendedIterator<Triple> find(Triple tripleMatch) {
        MatchPattern pattern = PatternClassifier.classify(tripleMatch);
        switch (pattern) {
            case SUB_PRE_OBJ: {
                return this.triples.containsKey(tripleMatch) ? new SingletonIterator<Triple>(tripleMatch) : NiceIterator.emptyIterator();
            }
            case SUB_ANY_ANY: 
            case ANY_PRE_ANY: 
            case ANY_ANY_OBJ: 
            case SUB_PRE_ANY: 
            case ANY_PRE_OBJ: 
            case SUB_ANY_OBJ: {
                return this.currentStrategy.findMatch(tripleMatch, pattern);
            }
            case ANY_ANY_ANY: {
                return this.triples.keyIterator();
            }
        }
        throw new IllegalStateException("Unknown pattern classifier: " + String.valueOf((Object)PatternClassifier.classify(tripleMatch)));
    }

    @Override
    public RoaringTripleStore copy() {
        return new RoaringTripleStore(this);
    }
}

