/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.ArgModuleGeneral;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.ModGeneral;
import org.apache.jena.cmd.ModVersion;
import org.apache.jena.cmd.TerminationException;
import org.apache.jena.cmd.Usage;

public abstract class CmdGeneral
extends CmdArgModule {
    protected ModGeneral modGeneral = new ModGeneral(this::printHelp);
    protected ModVersion modVersion = new ModVersion(true);
    private Usage usage = new Usage();
    protected String cmdName = null;

    protected CmdGeneral(String[] argv) {
        super(argv);
        this.addModule(this.modGeneral);
        this.addModule(this.modVersion);
    }

    @Override
    public void addModule(ArgModuleGeneral argModule) {
        super.addModule(argModule);
        argModule.registerWith(this);
    }

    protected boolean isVerbose() {
        return this.modGeneral.verbose;
    }

    protected boolean isQuiet() {
        return this.modGeneral.quiet;
    }

    protected boolean isDebug() {
        return this.modGeneral.debug;
    }

    protected boolean help() {
        return this.modGeneral.help;
    }

    public final void printHelp() {
        this.usage();
        throw new TerminationException(0);
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
    }

    protected abstract String getSummary();

    public void usage() {
        this.usage(System.err);
    }

    public void usage(PrintStream pStr) {
        IndentedWriter out = new IndentedWriter((OutputStream)pStr);
        out.println(this.getSummary());
        this.usage.output(out);
    }

    public void add(ArgDecl argDecl, String argName, String msg) {
        this.add(argDecl);
        this.getUsage().addUsage(argName, msg);
    }

    public Usage getUsage() {
        return this.usage;
    }
}

