/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.ModelAssembler;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;

public class UnionModelAssembler
extends ModelAssembler
implements Assembler {
    @Override
    protected Model openEmptyModel(Assembler a, Resource root2, Mode mode) {
        this.checkType(root2, JA.UnionModel);
        MultiUnion union = new MultiUnion();
        union.addGraph(this.getRootModel(a, root2, mode));
        this.addSubModels(a, root2, union, mode);
        return ModelFactory.createModelForGraph(union);
    }

    private Graph getRootModel(Assembler a, Resource root2, Mode mode) {
        Resource r = UnionModelAssembler.getUniqueResource(root2, JA.rootModel);
        return r == null ? GraphMemFactory.empty() : a.openModel(r, mode).getGraph();
    }

    private void addSubModels(Assembler a, Resource root2, MultiUnion union, Mode mode) {
        StmtIterator it = root2.listProperties(JA.subModel);
        while (it.hasNext()) {
            Resource resource = UnionModelAssembler.getResource(it.nextStatement());
            union.addGraph(a.openModel(resource, mode).getGraph());
        }
    }
}

