/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shex.ShexException;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.expressions.NumRangeKind;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.sparql.expr.NodeValue;

public class NumRangeConstraint
extends NodeConstraintComponent {
    private final NumRangeKind rangeKind;
    private final Node value;
    private final NodeValue numericValue;

    public NumRangeConstraint(NumRangeKind rangeKind, Node value) {
        Objects.requireNonNull(rangeKind);
        this.rangeKind = rangeKind;
        this.value = value;
        NodeValue nv = NodeValue.makeNode(value);
        if (!nv.isNumber()) {
            throw new ShexException("Not a number: " + String.valueOf(value));
        }
        this.numericValue = nv;
    }

    public NumRangeKind getRangeKind() {
        return this.rangeKind;
    }

    public Node getValue() {
        return this.value;
    }

    public NodeValue getNumericValue() {
        return this.numericValue;
    }

    @Override
    public ReportItem nodeSatisfies(ValidationContext vCxt, Node n) {
        if (!n.isLiteral()) {
            return new ReportItem("NumRange: Not a literal number", n);
        }
        NodeValue nv = NodeValue.makeNode(n);
        int r = NodeValue.compare(nv, this.numericValue);
        switch (this.rangeKind) {
            case MAXEXCLUSIVE: {
                if (r >= 0) break;
                return null;
            }
            case MAXINCLUSIVE: {
                if (r > 0) break;
                return null;
            }
            case MINEXCLUSIVE: {
                if (r <= 0) break;
                return null;
            }
            case MININCLUSIVE: {
                if (r < 0) break;
                return null;
            }
        }
        String msg = String.format("Expected %s %s : got = %s", this.rangeKind.label(), NodeFmtLib.strTTL(nv.getNode()), NodeFmtLib.strTTL(n));
        return new ReportItem(msg, n);
    }

    @Override
    public void visit(NodeConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.numericValue, this.rangeKind, this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumRangeConstraint other = (NumRangeConstraint)obj;
        return Objects.equals(this.numericValue, other.numericValue) && this.rangeKind == other.rangeKind && Objects.equals(this.value, other.value);
    }

    @Override
    public String toString() {
        return "NumRange[" + this.rangeKind.label() + " " + NodeFmtLib.displayStr(this.value) + "]";
    }
}

