/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto;

import java.security.SecureRandom;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.lang.util.ByteSource;

public class SecureRandomNumberGenerator
implements RandomNumberGenerator {
    protected static final int DEFAULT_NEXT_BYTES_SIZE = 16;
    private int defaultNextBytesSize = 16;
    private SecureRandom secureRandom = new SecureRandom();

    public void setSeed(byte[] bytes) {
        this.secureRandom.setSeed(bytes);
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom random) throws NullPointerException {
        if (random == null) {
            throw new NullPointerException("SecureRandom argument cannot be null.");
        }
        this.secureRandom = random;
    }

    public int getDefaultNextBytesSize() {
        return this.defaultNextBytesSize;
    }

    public void setDefaultNextBytesSize(int defaultNextBytesSize) throws IllegalArgumentException {
        if (defaultNextBytesSize <= 0) {
            throw new IllegalArgumentException("size value must be a positive integer (1 or larger)");
        }
        this.defaultNextBytesSize = defaultNextBytesSize;
    }

    @Override
    public ByteSource nextBytes() {
        return this.nextBytes(this.getDefaultNextBytesSize());
    }

    @Override
    public ByteSource nextBytes(int numBytes) {
        if (numBytes <= 0) {
            throw new IllegalArgumentException("numBytes argument must be a positive integer (1 or larger)");
        }
        byte[] bytes = new byte[numBytes];
        this.secureRandom.nextBytes(bytes);
        return ByteSource.Util.bytes(bytes);
    }
}

