/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gco;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import javax.measure.Unit;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gml.Measure;

public class UnitAdapter
extends XmlAdapter<String, Unit<?>> {
    @Override
    public final Unit<?> unmarshal(String value) throws IllegalArgumentException {
        Context context2 = Context.current();
        return Context.converter(context2).toUnit(context2, value);
    }

    @Override
    public String marshal(Unit<?> value) {
        return value != null ? value.toString() : null;
    }

    public static final class Since2014
    extends UnitAdapter {
        @Override
        public String marshal(Unit<?> value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }

    public static final class ForCS
    extends UnitAdapter {
        @Override
        public String marshal(Unit<?> value) {
            return Measure.getUOM(value, false, true);
        }
    }
}

