/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.MemoryUtils;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadIdPool<E>
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadIdPool.class);
    private static final int SPREAD_FACTOR = MemoryUtils.getReferencesPerCacheLine();
    private final int _capacity;
    private final AtomicReferenceArray<E> _items;

    public ThreadIdPool() {
        this(-1);
    }

    public ThreadIdPool(int capacity) {
        this._capacity = ThreadIdPool.calcCapacity(capacity);
        this._items = new AtomicReferenceArray((this._capacity + 1) * SPREAD_FACTOR);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)this);
        }
    }

    private static int calcCapacity(int capacity) {
        if (capacity >= 0) {
            return capacity;
        }
        return 2 * MathUtils.ceilToNextPowerOfTwo(ProcessorUtils.availableProcessors());
    }

    private static int toSlot(int index) {
        return (index + 1) * SPREAD_FACTOR;
    }

    public int capacity() {
        return this._capacity;
    }

    public int size() {
        int available = 0;
        for (int i = 0; i < this.capacity(); ++i) {
            if (this._items.getPlain(ThreadIdPool.toSlot(i)) == null) continue;
            ++available;
        }
        return available;
    }

    public int offer(E e2) {
        int capacity = this.capacity();
        if (capacity > 0) {
            int index = (int)(Thread.currentThread().getId() % (long)capacity);
            for (int i = 0; i < capacity; ++i) {
                if (this._items.compareAndSet(ThreadIdPool.toSlot(index), null, e2)) {
                    return index;
                }
                if (++index != capacity) continue;
                index = 0;
            }
        }
        return -1;
    }

    public E take() {
        int capacity = this.capacity();
        if (capacity == 0) {
            return null;
        }
        int index = (int)(Thread.currentThread().getId() % (long)capacity);
        for (int i = 0; i < capacity; ++i) {
            E e2 = this._items.getAndSet(ThreadIdPool.toSlot(index), null);
            if (e2 != null) {
                return e2;
            }
            if (++index != capacity) continue;
            index = 0;
        }
        return null;
    }

    public boolean remove(E e2, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this._items.compareAndSet(ThreadIdPool.toSlot(index), e2, null);
    }

    public List<E> removeAll() {
        int capacity = this.capacity();
        ArrayList<Object> all = new ArrayList<Object>(capacity);
        for (int i = 0; i < capacity; ++i) {
            Object e2 = this._items.getAndSet(ThreadIdPool.toSlot(i), null);
            if (e2 == null) continue;
            all.add(e2);
        }
        return all;
    }

    public E takeOrElse(Supplier<E> supplier) {
        E e2 = this.take();
        return e2 == null ? supplier.get() : e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Supplier<E> supplier, Function<E, R> function) {
        E e2 = this.takeOrElse(supplier);
        try {
            R r = function.apply(e2);
            return r;
        }
        finally {
            this.offer(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, R> R apply(Supplier<E> supplier, BiFunction<E, A, R> function, A argument) {
        E e2 = this.takeOrElse(supplier);
        try {
            R r = function.apply(e2, argument);
            return r;
        }
        finally {
            this.offer(e2);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        int capacity = this.capacity();
        ArrayList<Dumpable> slots = new ArrayList<Dumpable>(capacity);
        for (int i = 0; i < capacity; ++i) {
            E slot = this._items.get(ThreadIdPool.toSlot(i));
            if (slot == null) continue;
            slots.add(Dumpable.named(Integer.toString(i), slot));
        }
        Dumpable.dumpObjects(out, indent, this, slots.toArray());
    }

    public String toString() {
        return String.format("%s@%x{capacity=%d}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.capacity());
    }
}

