/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.oapi.OpenApiBeanPropertyMeta;
import org.apache.juneau.oapi.OpenApiClassMeta;
import org.apache.juneau.oapi.OpenApiCommon;
import org.apache.juneau.oapi.OpenApiMetaProvider;
import org.apache.juneau.oapi.OpenApiSerializerBuilder;
import org.apache.juneau.oapi.OpenApiSerializerSession;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.uon.UonSerializer;

@ConfigurableContext
public class OpenApiSerializer
extends UonSerializer
implements OpenApiMetaProvider,
OpenApiCommon {
    static final String PREFIX = "OpenApiSerializer";
    public static final OpenApiSerializer DEFAULT = new OpenApiSerializer(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, OpenApiClassMeta> openApiClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, OpenApiBeanPropertyMeta> openApiBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, OpenApiBeanPropertyMeta>();

    public OpenApiSerializer(PropertyStore ps, String produces, String accept) {
        super(ps.builder().set("UonSerializer.encoding.b", false).build(), produces, accept);
    }

    public OpenApiSerializer(PropertyStore ps) {
        this(ps, "text/openapi", null);
    }

    @Override
    public OpenApiSerializerBuilder builder() {
        return new OpenApiSerializerBuilder(this.getPropertyStore());
    }

    public static OpenApiSerializerBuilder create() {
        return new OpenApiSerializerBuilder();
    }

    @Override
    public OpenApiSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public OpenApiSerializerSession createSession(SerializerSessionArgs args) {
        return new OpenApiSerializerSession(this, args);
    }

    @Override
    public OpenApiSerializerSession createPartSession() {
        return this.createPartSession(null);
    }

    @Override
    public OpenApiSerializerSession createPartSession(SerializerSessionArgs args) {
        return new OpenApiSerializerSession(this, args);
    }

    @Override
    public String serialize(HttpPartType partType, HttpPartSchema schema, Object value) throws SchemaValidationException, SerializeException {
        return this.createPartSession().serialize(partType, schema, value);
    }

    @Override
    public String serialize(HttpPartSchema schema, Object value) throws SchemaValidationException, SerializeException {
        return this.createPartSession().serialize(null, schema, value);
    }

    @Override
    public OpenApiClassMeta getOpenApiClassMeta(ClassMeta<?> cm) {
        OpenApiClassMeta m = this.openApiClassMetas.get(cm);
        if (m == null) {
            m = new OpenApiClassMeta(cm, this);
            this.openApiClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public OpenApiBeanPropertyMeta getOpenApiBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return OpenApiBeanPropertyMeta.DEFAULT;
        }
        OpenApiBeanPropertyMeta m = this.openApiBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new OpenApiBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.openApiBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

