/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.TargetedAnnotationImpl;
import org.apache.juneau.annotation.TargetedAnnotationMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class BeanpAnnotation {
    public static final Beanp DEFAULT = BeanpAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String ... on) {
        return BeanpAnnotation.create().on(on);
    }

    public static Beanp copy(Beanp a, VarResolverSession r) {
        return BeanpAnnotation.create().dictionary(a.dictionary()).format(r.resolve(a.format())).name(r.resolve(a.name())).on(r.resolve(a.on())).params(a.params()).properties(r.resolve(a.properties())).ro(r.resolve(a.ro())).type(a.type()).value(r.resolve(a.value())).wo(r.resolve(a.wo())).build();
    }

    public static class Builder
    extends TargetedAnnotationMFBuilder {
        Class<?> type = Void.TYPE;
        Class<?>[] dictionary = new Class[0];
        Class<?>[] params = new Class[0];
        String format = "";
        String name = "";
        String properties = "";
        String ro = "";
        String value = "";
        String wo = "";

        protected Builder() {
            super(Beanp.class);
        }

        public Beanp build() {
            return new Impl(this);
        }

        public Builder dictionary(Class<?> ... value) {
            this.dictionary = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder params(Class<?> ... value) {
            this.params = value;
            return this;
        }

        public Builder properties(String value) {
            this.properties = value;
            return this;
        }

        public Builder ro(String value) {
            this.ro = value;
            return this;
        }

        public Builder type(Class<?> value) {
            this.type = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder wo(String value) {
            this.wo = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Beanp[] value();
    }

    public static class Applier
    extends AnnotationApplier<Beanp, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Beanp.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Beanp> ai, BeanContext.Builder b) {
            Beanp a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on())) {
                return;
            }
            b.annotations(BeanpAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationImpl
    implements Beanp {
        private final Class<?> type;
        private final Class<?>[] params;
        private final Class<?>[] dictionary;
        private final String name;
        private final String value;
        private final String properties;
        private final String format;
        private final String ro;
        private final String wo;

        Impl(Builder b) {
            super(b);
            this.dictionary = ArrayUtils.copyOf(b.dictionary);
            this.format = b.format;
            this.name = b.name;
            this.params = ArrayUtils.copyOf(b.params);
            this.properties = b.properties;
            this.ro = b.ro;
            this.type = b.type;
            this.value = b.value;
            this.wo = b.wo;
            this.postConstruct();
        }

        @Override
        public Class<?>[] dictionary() {
            return this.dictionary;
        }

        @Override
        public String format() {
            return this.format;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<?>[] params() {
            return this.params;
        }

        @Override
        public String properties() {
            return this.properties;
        }

        @Override
        public String ro() {
            return this.ro;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String wo() {
            return this.wo;
        }
    }
}

