/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.RestChildMatch;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.rest.util.UrlPathMatcher;

public class RestChildren {
    private final Map<String, RestContext> children = CollectionUtils.synced(CollectionUtils.map());

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public RestChildren(Builder builder) {
        for (RestContext rc : builder.list) {
            this.children.put(rc.getPath(), rc);
        }
    }

    public Map<String, RestContext> asMap() {
        return CollectionUtils.u(this.children);
    }

    public void destroy() {
        for (RestContext r : this.children.values()) {
            r.destroy();
            if (!(r.getResource() instanceof Servlet)) continue;
            ((Servlet)r.getResource()).destroy();
        }
    }

    public Optional<RestChildMatch> findMatch(RestSession.Builder builder) {
        String pi = builder.getPathInfoUndecoded();
        if (!this.children.isEmpty() && Utils.nn(pi) && !pi.equals("/")) {
            for (RestContext rc : this.children.values()) {
                UrlPathMatcher upp = rc.getPathMatcher();
                UrlPathMatch uppm = upp.match(builder.getUrlPath());
                if (!Utils.nn(uppm)) continue;
                return Utils.opt(RestChildMatch.create(uppm, rc));
            }
        }
        return Utils.opte();
    }

    public void postInit() throws ServletException {
        for (RestContext childContext : this.children.values()) {
            childContext.postInit();
        }
    }

    public void postInitChildFirst() throws ServletException {
        for (RestContext childContext : this.children.values()) {
            childContext.postInitChildFirst();
        }
    }

    public static class Builder
    extends BeanBuilder<RestChildren> {
        final List<RestContext> list = CollectionUtils.list(new RestContext[0]);

        protected Builder(BeanStore beanStore) {
            super(RestChildren.class, beanStore);
        }

        public Builder add(RestContext value) {
            this.list.add(value);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected RestChildren buildDefault() {
            return new RestChildren(this);
        }
    }

    public final class Void
    extends RestChildren {
        public Void(Builder builder) throws Exception {
            super(builder);
        }
    }
}

