/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.ServerVariable;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Server
extends OpenApiElement {
    private URI url;
    private String description;
    private Map<String, ServerVariable> variables = CollectionUtils.map();

    public Server() {
    }

    public Server(Server copyFrom) {
        super(copyFrom);
        this.url = copyFrom.url;
        this.description = copyFrom.description;
        if (Utils.nn(copyFrom.variables)) {
            this.variables.putAll(CollectionUtils.copyOf(copyFrom.variables, ServerVariable::copy));
        }
    }

    public Server addVariable(String key, ServerVariable value) {
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        this.variables.put(key, value);
        return this;
    }

    public Server copy() {
        return new Server(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "url" -> ConverterUtils.toType((Object)this.getUrl(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "variables" -> ConverterUtils.toType(this.getVariables(), type);
            default -> super.get(property, type);
        });
    }

    public String getDescription() {
        return this.description;
    }

    public URI getUrl() {
        return this.url;
    }

    public Map<String, ServerVariable> getVariables() {
        return Utils.nullIfEmpty(this.variables);
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.url), (Object)"url").addIf(Utils.ne(this.variables), (Object)"variables").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Server set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "url" -> this.setUrl(StringUtils.toUri((Object)value));
            case "variables" -> this.setVariables(ConverterUtils.toMapBuilder((Object)value, String.class, ServerVariable.class).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Server setDescription(String value) {
        this.description = value;
        return this;
    }

    public Server setUrl(URI value) {
        this.url = value;
        return this;
    }

    public Server setVariables(Map<String, ServerVariable> value) {
        this.variables.clear();
        if (Utils.nn(value)) {
            this.variables.putAll(value);
        }
        return this;
    }

    @Override
    public Server strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected Server strict() {
        super.strict();
        return this;
    }
}

