/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Resolver;
import org.apache.karaf.features.internal.EventAdminListener;
import org.apache.karaf.region.persist.RegionsPersistence;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleManager.class);
    private final BundleContext bundleContext;
    private final RegionsPersistence regionsPersistence;
    private final long refreshTimeout;
    private List<String> defaultProtocols = Arrays.asList("http", "https", "ftp", "file", "jar");

    public BundleManager(BundleContext bundleContext) {
        this(bundleContext, null);
    }

    public BundleManager(BundleContext bundleContext, RegionsPersistence regionsPersistence) {
        this(bundleContext, regionsPersistence, 5000L);
    }

    public BundleManager(BundleContext bundleContext, RegionsPersistence regionsPersistence, long refreshTimeout) {
        this.bundleContext = bundleContext;
        this.regionsPersistence = regionsPersistence;
        this.refreshTimeout = refreshTimeout;
    }

    public BundleInstallerResult installBundleIfNeeded(String bundleLocation, int startLevel, String regionName) throws IOException, BundleException {
        Bundle foundByLocationBundle = this.findInstalledByLocation(bundleLocation);
        if (foundByLocationBundle != null) {
            LOGGER.debug("Found installed bundle by location: {}", (Object)foundByLocationBundle);
            return new BundleInstallerResult(foundByLocationBundle, false);
        }
        BundleInstallerResult result = this.doInstallBundleIfNeeded(bundleLocation, startLevel);
        this.installToRegion(regionName, result.bundle, result.isNew);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleInstallerResult doInstallBundleIfNeeded(String bundleLocation, int startLevel) throws IOException, BundleException {
        InputStream is = this.getInputStreamForBundle(bundleLocation);
        try {
            String vStr;
            Version v;
            Bundle existingBundle;
            String sn;
            is.mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            if (m == null) {
                ZipEntry entry;
                while ((entry = jar.getNextEntry()) != null) {
                    if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                    m = new Manifest(jar);
                    break;
                }
                if (m == null) {
                    throw new BundleException("Manifest not present in the zip " + bundleLocation);
                }
            }
            if ((sn = m.getMainAttributes().getValue("Bundle-SymbolicName")) == null) {
                throw new BundleException("Jar is not a bundle, no Bundle-SymbolicName " + bundleLocation);
            }
            int attributeIndexSep = sn.indexOf(59);
            if (attributeIndexSep != -1) {
                sn = sn.substring(0, attributeIndexSep);
            }
            if ((existingBundle = this.findInstalled(sn, v = (vStr = m.getMainAttributes().getValue("Bundle-Version")) == null ? Version.emptyVersion : Version.parseVersion((String)vStr))) != null) {
                LOGGER.debug("Found installed bundle: " + existingBundle);
                BundleInstallerResult bundleInstallerResult = new BundleInstallerResult(existingBundle, false);
                return bundleInstallerResult;
            }
            try {
                is.reset();
            }
            catch (IOException e) {
                is.close();
                is = new URL(bundleLocation).openStream();
            }
            is = new FilterInputStream(is){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedIOException();
                    }
                    return super.read(b, off, len);
                }
            };
            LOGGER.debug("Installing bundle " + bundleLocation);
            Bundle b = this.bundleContext.installBundle(bundleLocation, is);
            if (startLevel > 0) {
                ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
            }
            BundleInstallerResult bundleInstallerResult = new BundleInstallerResult(b, true);
            return bundleInstallerResult;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle isBundleInstalled(String bundleLocation) throws IOException, BundleException {
        Bundle foundByLocationBundle = this.findInstalledByLocation(bundleLocation);
        if (foundByLocationBundle != null) {
            return foundByLocationBundle;
        }
        InputStream is = this.getInputStreamForBundle(bundleLocation);
        try {
            String vStr;
            Version v;
            Bundle existingBundle;
            String sn;
            is.mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            if (m == null) {
                ZipEntry entry;
                while ((entry = jar.getNextEntry()) != null) {
                    if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                    m = new Manifest(jar);
                    break;
                }
                if (m == null) {
                    throw new BundleException("Manifest not present in the zip " + bundleLocation);
                }
            }
            if ((sn = m.getMainAttributes().getValue("Bundle-SymbolicName")) == null) {
                throw new BundleException("Jar is not a bundle, no Bundle-SymbolicName " + bundleLocation);
            }
            int attributeIndexSep = sn.indexOf(59);
            if (attributeIndexSep != -1) {
                sn = sn.substring(0, attributeIndexSep);
            }
            if ((existingBundle = this.findInstalled(sn, v = (vStr = m.getMainAttributes().getValue("Bundle-Version")) == null ? Version.emptyVersion : Version.parseVersion((String)vStr))) != null) {
                LOGGER.debug("Found installed bundle: " + existingBundle);
                Bundle bundle = existingBundle;
                return bundle;
            }
            Bundle bundle = null;
            return bundle;
        }
        finally {
            is.close();
        }
    }

    private Bundle findInstalled(String symbolicName, Version version) {
        for (Bundle b : this.bundleContext.getBundles()) {
            Version bv;
            if (b.getSymbolicName() == null || !b.getSymbolicName().equals(symbolicName)) continue;
            String vStr = (String)b.getHeaders().get("Bundle-Version");
            Version version2 = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            if (!version.equals((Object)bv)) continue;
            return b;
        }
        return null;
    }

    private Bundle findInstalledByLocation(String location) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (b.getLocation() == null || !b.getLocation().equals(location)) continue;
            return b;
        }
        return null;
    }

    private InputStream getInputStreamForBundle(String bundleLocation) throws MalformedURLException, IOException {
        BufferedInputStream is;
        LOGGER.debug("Checking " + bundleLocation);
        try {
            String protocol;
            int protocolIndex = bundleLocation.indexOf(":");
            if (protocolIndex != -1 && !(protocol = bundleLocation.substring(0, protocolIndex)).endsWith("file") && !protocol.endsWith("http")) {
                this.waitForUrlHandler(protocol);
            }
            URL bundleUrl = new URL(bundleLocation);
            is = new BufferedInputStream(bundleUrl.openStream());
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        return is;
    }

    private void installToRegion(String region, Bundle b, boolean isNew) throws BundleException {
        if (region != null && isNew) {
            if (this.regionsPersistence != null) {
                this.regionsPersistence.install(b, region);
            } else {
                throw new RuntimeException("Unable to find RegionsPersistence service, while installing " + region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForUrlHandler(String protocol) {
        if (!this.defaultProtocols.contains(protocol)) {
            try {
                Filter filter = this.bundleContext.createFilter("(&(objectClass=" + URLStreamHandlerService.class.getName() + ")(url.handler.protocol=" + protocol + "))");
                if (filter == null) {
                    return;
                }
                ServiceTracker urlHandlerTracker = new ServiceTracker(this.bundleContext, filter, null);
                try {
                    urlHandlerTracker.open();
                    urlHandlerTracker.waitForService(30000L);
                }
                catch (InterruptedException e) {
                    LOGGER.debug("Interrupted while waiting for URL handler for protocol {}.", (Object)protocol);
                }
                finally {
                    urlHandlerTracker.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error creating service tracker.", (Throwable)ex);
            }
        }
    }

    protected Set<Bundle> findBundlesToRefresh(Set<Bundle> existing, Set<Bundle> installed) {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        bundles.addAll(this.findBundlesWithOptionalPackagesToRefresh(existing, installed));
        bundles.addAll(this.findBundlesWithFragmentsToRefresh(existing, installed));
        return bundles;
    }

    protected Set<Bundle> findBundlesWithFragmentsToRefresh(Set<Bundle> existing, Set<Bundle> installed) {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        HashSet<Bundle> oldBundles = new HashSet<Bundle>(existing);
        oldBundles.removeAll(installed);
        if (!oldBundles.isEmpty()) {
            for (Bundle b : installed) {
                Clause[] clauses;
                String hostHeader = (String)b.getHeaders().get("Fragment-Host");
                if (hostHeader == null || (clauses = Parser.parseHeader(hostHeader)) == null || clauses.length <= 0) continue;
                Clause path = clauses[0];
                for (Bundle hostBundle : oldBundles) {
                    if (!hostBundle.getSymbolicName().equals(path.getName())) continue;
                    String ver = path.getAttribute("bundle-version");
                    if (ver != null) {
                        VersionRange v = VersionRange.parseVersionRange(ver);
                        if (!v.contains(hostBundle.getVersion())) continue;
                        bundles.add(hostBundle);
                        continue;
                    }
                    bundles.add(hostBundle);
                }
            }
        }
        return bundles;
    }

    protected Set<Bundle> findBundlesWithOptionalPackagesToRefresh(Set<Bundle> existing, Set<Bundle> installed) {
        List importsList;
        HashSet<Bundle> bundles = new HashSet<Bundle>(existing);
        bundles.removeAll(installed);
        if (bundles.isEmpty()) {
            return bundles;
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b = (Bundle)it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            importsList = this.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (bundles.isEmpty()) {
            return bundles;
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        for (Bundle b : installed) {
            String exportsStr = (String)b.getHeaders().get("Export-Package");
            if (exportsStr == null) continue;
            Clause[] exportsList = Parser.parseHeader(exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator it2 = bundles.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                for (Clause pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange(ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (importsList.isEmpty()) {
                it2.remove();
                continue;
            }
            LOGGER.debug("Refeshing bundle {} ({}) to solve the following optional imports", (Object)b.getSymbolicName(), (Object)b.getBundleId());
            for (Clause p : importsList) {
                LOGGER.debug("    {}", (Object)p);
            }
        }
        return bundles;
    }

    protected List<Clause> getOptionalImports(String importsStr) {
        Clause[] imports = Parser.parseHeader(importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (Clause anImport : imports) {
            String resolution = anImport.getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(anImport);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshPackages(Collection<Bundle> bundles) {
        final Object refreshLock = new Object();
        FrameworkWiring wiring = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
        if (wiring != null) {
            Object object = refreshLock;
            synchronized (object) {
                wiring.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void frameworkEvent(FrameworkEvent event) {
                        if (event.getType() == 4) {
                            Object object = refreshLock;
                            synchronized (object) {
                                refreshLock.notifyAll();
                            }
                        }
                    }
                }});
                try {
                    refreshLock.wait(this.refreshTimeout);
                }
                catch (InterruptedException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void uninstall(Set<Bundle> bundles) {
        this.uninstall(bundles, true);
    }

    public void uninstall(Set<Bundle> bundles, boolean refresh) {
        for (Bundle b : bundles) {
            try {
                b.uninstall();
            }
            catch (Exception e2) {}
        }
        if (refresh) {
            this.refreshPackages(null);
        }
    }

    public void uninstall(List<Bundle> bundles) {
        this.uninstall(bundles, true);
    }

    public void uninstall(List<Bundle> bundles, boolean refresh) {
        for (Bundle b : bundles) {
            try {
                b.uninstall();
            }
            catch (Exception e2) {}
        }
        if (refresh) {
            this.refreshPackages(null);
        }
    }

    public void uninstallById(Set<Long> bundles) throws BundleException, InterruptedException {
        this.uninstallById(bundles, true);
    }

    public void uninstallById(Set<Long> bundles, boolean refresh) throws BundleException, InterruptedException {
        for (long bundleId : bundles) {
            Bundle b = this.bundleContext.getBundle(bundleId);
            if (b == null) continue;
            b.uninstall();
        }
        if (refresh) {
            this.refreshPackages(null);
        }
    }

    public File getDataFile(String fileName) {
        return this.bundleContext.getDataFile(fileName);
    }

    EventAdminListener createAndRegisterEventAdminListener() {
        EventAdminListener listener = null;
        try {
            this.getClass().getClassLoader().loadClass("org.bundles.service.event.EventAdmin");
            listener = new EventAdminListener(this.bundleContext);
        }
        catch (Throwable t) {
            LOGGER.debug("EventAdmin package is not available, just don't use it");
        }
        return listener;
    }

    public ServiceTracker createServiceTrackerForResolverName(String resolver) throws InvalidSyntaxException {
        String filter = "(&(objectClass=" + Resolver.class.getName() + ")(name=" + resolver + "))";
        return new ServiceTracker(this.bundleContext, FrameworkUtil.createFilter((String)filter), null);
    }

    public void refreshBundles(Set<Bundle> existing, Set<Bundle> installed, EnumSet<FeaturesService.Option> options) {
        boolean refresh;
        boolean print = options.contains((Object)FeaturesService.Option.PrintBundlesToRefresh);
        boolean bl = refresh = !options.contains((Object)FeaturesService.Option.NoAutoRefreshBundles);
        if (print || refresh) {
            Set<Bundle> bundlesToRefresh = this.findBundlesToRefresh(existing, installed);
            StringBuilder sb = new StringBuilder();
            for (Bundle b : bundlesToRefresh) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(b.getSymbolicName()).append(" (").append(b.getBundleId()).append(")");
            }
            LOGGER.debug("Bundles to refresh: {}", (Object)sb.toString());
            if (!bundlesToRefresh.isEmpty()) {
                if (print) {
                    if (refresh) {
                        System.out.println("Refreshing bundles " + sb.toString());
                    } else {
                        System.out.println("The following bundles may need to be refreshed: " + sb.toString());
                    }
                }
                if (refresh) {
                    LOGGER.debug("Refreshing bundles: {}", (Object)sb.toString());
                    this.refreshPackages(bundlesToRefresh);
                }
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public static class BundleInstallerResult {
        Bundle bundle;
        boolean isNew;

        public BundleInstallerResult(Bundle bundle, boolean isNew) {
            this.bundle = bundle;
            this.isNew = isNew;
        }
    }
}

