/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.namespace;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class NamespaceHandlerRegistryImpl
implements NamespaceHandlerRegistry,
ServiceTrackerCustomizer {
    public static final String NAMESPACE = "osgi.service.blueprint.namespace";
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceHandlerRegistryImpl.class);
    private final BundleContext bundleContext;
    private final ServiceTracker tracker;
    private final ConcurrentHashMap<URI, CopyOnWriteArraySet<NamespaceHandler>> handlers = new ConcurrentHashMap();
    private final LRUMap<Map<URI, NamespaceHandler>, Reference<Schema>> schemas = new LRUMap(10);
    private final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final ArrayList<NamespaceHandlerSetImpl> sets = new ArrayList();

    public NamespaceHandlerRegistryImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.tracker = new ServiceTracker(bundleContext, NamespaceHandler.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public Object addingService(ServiceReference reference) {
        LOGGER.debug("Adding NamespaceHandler " + reference.toString());
        NamespaceHandler handler = (NamespaceHandler)this.bundleContext.getService(reference);
        if (handler != null) {
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (String name : reference.getPropertyKeys()) {
                    props.put(name, reference.getProperty(name));
                }
                this.registerHandler(handler, props);
            }
            catch (Exception e) {
                LOGGER.warn("Error registering NamespaceHandler", (Throwable)e);
            }
        } else {
            Bundle bundle = reference.getBundle();
            if (bundle != null) {
                LOGGER.warn("Error resolving NamespaceHandler, null Service obtained from tracked ServiceReference {} for bundle {}/{}", new Object[]{reference.toString(), reference.getBundle().getSymbolicName(), reference.getBundle().getVersion()});
            }
        }
        return handler;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        try {
            LOGGER.debug("Removing NamespaceHandler " + reference.toString());
            NamespaceHandler handler = (NamespaceHandler)service;
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String name : reference.getPropertyKeys()) {
                props.put(name, reference.getProperty(name));
            }
            this.unregisterHandler(handler, props);
        }
        catch (Exception e) {
            LOGGER.warn("Error unregistering NamespaceHandler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(NamespaceHandler handler, Map properties) {
        List<URI> namespaces = NamespaceHandlerRegistryImpl.getNamespaces(properties);
        for (URI uri : namespaces) {
            ArrayList<NamespaceHandlerSetImpl> sets;
            CopyOnWriteArraySet<NamespaceHandler> h = this.handlers.putIfAbsent(uri, new CopyOnWriteArraySet());
            if (h == null) {
                h = this.handlers.get(uri);
            }
            if (!h.add(handler)) continue;
            ArrayList<NamespaceHandlerSetImpl> arrayList = this.sets;
            synchronized (arrayList) {
                sets = new ArrayList<NamespaceHandlerSetImpl>(this.sets);
            }
            for (NamespaceHandlerSetImpl s : sets) {
                s.registerHandler(uri, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(NamespaceHandler handler, Map properties) {
        List<URI> namespaces = NamespaceHandlerRegistryImpl.getNamespaces(properties);
        for (URI uri : namespaces) {
            ArrayList<NamespaceHandlerSetImpl> sets;
            CopyOnWriteArraySet<NamespaceHandler> h = this.handlers.get(uri);
            if (!h.remove(handler)) continue;
            ArrayList<NamespaceHandlerSetImpl> arrayList = this.sets;
            synchronized (arrayList) {
                sets = new ArrayList<NamespaceHandlerSetImpl>(this.sets);
            }
            for (NamespaceHandlerSetImpl s : sets) {
                s.unregisterHandler(uri, handler);
            }
        }
        this.removeSchemasFor(handler);
    }

    private static List<URI> getNamespaces(Map properties) {
        Object ns;
        Object v0 = ns = properties != null ? properties.get(NAMESPACE) : null;
        if (ns == null) {
            throw new IllegalArgumentException("NamespaceHandler service does not have an associated osgi.service.blueprint.namespace property defined");
        }
        if (ns instanceof URI[]) {
            return Arrays.asList(ns);
        }
        if (ns instanceof URI) {
            return Collections.singletonList(ns);
        }
        if (ns instanceof String) {
            return Collections.singletonList(URI.create(ns));
        }
        if (ns instanceof String[]) {
            String[] strings = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(strings.length);
            for (String string : strings) {
                namespaces.add(URI.create(string));
            }
            return namespaces;
        }
        if (ns instanceof Collection) {
            Collection col = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(col.size());
            for (Object o : col) {
                namespaces.add(NamespaceHandlerRegistryImpl.toURI(o));
            }
            return namespaces;
        }
        if (ns instanceof Object[]) {
            Object[] array = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(array.length);
            for (Object o : array) {
                namespaces.add(NamespaceHandlerRegistryImpl.toURI(o));
            }
            return namespaces;
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated osgi.service.blueprint.namespace property defined which can not be converted to an array of URI");
    }

    private static URI toURI(Object o) {
        if (o instanceof URI) {
            return (URI)o;
        }
        if (o instanceof String) {
            return URI.create((String)o);
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated osgi.service.blueprint.namespace property defined which can not be converted to an array of URI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceHandlerSet getNamespaceHandlers(Set<URI> uris, Bundle bundle) {
        NamespaceHandlerSetImpl s;
        ArrayList<NamespaceHandlerSetImpl> arrayList = this.sets;
        synchronized (arrayList) {
            s = new NamespaceHandlerSetImpl(uris, bundle);
            this.sets.add(s);
        }
        return s;
    }

    @Override
    public void destroy() {
        this.tracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getExistingSchema(Map<URI, NamespaceHandler> handlers) {
        LRUMap<Map<URI, NamespaceHandler>, Reference<Schema>> lRUMap = this.schemas;
        synchronized (lRUMap) {
            for (Map key : this.schemas.keySet()) {
                boolean found = true;
                for (URI uri : handlers.keySet()) {
                    if (handlers.get(uri).equals(key.get(uri))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return this.schemas.get(key).get();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSchemasFor(NamespaceHandler handler) {
        LRUMap<Map<URI, NamespaceHandler>, Reference<Schema>> lRUMap = this.schemas;
        synchronized (lRUMap) {
            ArrayList<Map> keys = new ArrayList<Map>();
            for (Map key : this.schemas.keySet()) {
                if (!key.values().contains(handler)) continue;
                keys.add(key);
            }
            for (Map key : keys) {
                this.schemas.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheSchema(Map<URI, NamespaceHandler> handlers, Schema schema) {
        LRUMap<Map<URI, NamespaceHandler>, Reference<Schema>> lRUMap = this.schemas;
        synchronized (lRUMap) {
            Iterator iterator = this.schemas.keySet().iterator();
            while (iterator.hasNext()) {
                Map key = (Map)iterator.next();
                boolean found = true;
                for (URI uri : key.keySet()) {
                    if (((NamespaceHandler)key.get(uri)).equals(handlers.get(uri))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                iterator.remove();
                break;
            }
            this.schemas.put(handlers, new SoftReference<Schema>(schema));
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class LRUMap<K, V>
    extends AbstractMap<K, V> {
        private final int bound;
        private final LinkedList<Map.Entry<K, V>> entries = new LinkedList();

        private LRUMap(int bound) {
            this.bound = bound;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            for (Map.Entry entry : this.entries) {
                if (!entry.getKey().equals(key)) continue;
                this.entries.remove(entry);
                this.entries.addFirst(entry);
                return entry.getValue();
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            if (key == null) {
                throw new NullPointerException();
            }
            V old = null;
            for (Map.Entry entry : this.entries) {
                if (!entry.getKey().equals(key)) continue;
                this.entries.remove(entry);
                old = entry.getValue();
                break;
            }
            if (value != null) {
                this.entries.addFirst(new LRUEntry(key, value));
                while (this.entries.size() > this.bound) {
                    this.entries.removeLast();
                }
            }
            return old;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return LRUMap.this.entries.iterator();
                }

                @Override
                public int size() {
                    return LRUMap.this.entries.size();
                }
            };
        }

        private static class LRUEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private final V value;

            private LRUEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected class NamespaceHandlerSetImpl
    implements NamespaceHandlerSet {
        private final List<NamespaceHandlerSet.Listener> listeners;
        private final Bundle bundle;
        private final Set<URI> namespaces;
        private final Map<URI, NamespaceHandler> handlers;
        private final Properties schemaMap = new Properties();
        private Schema schema;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NamespaceHandlerSetImpl(Set<URI> namespaces, Bundle bundle) {
            this.listeners = new CopyOnWriteArrayList<NamespaceHandlerSet.Listener>();
            this.namespaces = new HashSet<URI>(namespaces);
            this.bundle = bundle;
            this.handlers = new ConcurrentHashMap<URI, NamespaceHandler>();
            for (URI ns : namespaces) {
                this.findCompatibleNamespaceHandler(ns);
            }
            URL url = bundle.getResource("OSGI-INF/blueprint/schema.map");
            if (url != null) {
                InputStream ins = null;
                try {
                    ins = url.openStream();
                    this.schemaMap.load(ins);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    NamespaceHandlerRegistryImpl.closeQuietly(ins);
                }
            }
            for (Object ns : this.schemaMap.keySet()) {
                try {
                    this.namespaces.remove(new URI(ns.toString()));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }

        @Override
        public boolean isComplete() {
            return this.handlers.size() == this.namespaces.size();
        }

        @Override
        public Set<URI> getNamespaces() {
            return this.namespaces;
        }

        @Override
        public NamespaceHandler getNamespaceHandler(URI namespace) {
            return this.handlers.get(namespace);
        }

        @Override
        public Schema getSchema() throws SAXException, IOException {
            return this.getSchema(null);
        }

        @Override
        public Schema getSchema(Map<String, String> locations) throws SAXException, IOException {
            if (!this.isComplete()) {
                throw new IllegalStateException("NamespaceHandlerSet is not complete");
            }
            if (this.schema == null) {
                this.schema = this.doGetSchema(locations);
            }
            return this.schema;
        }

        private Schema doGetSchema(Map<String, String> locations) throws IOException, SAXException {
            if (this.schemaMap != null && !this.schemaMap.isEmpty()) {
                return this.createSchema(locations);
            }
            Schema schema = NamespaceHandlerRegistryImpl.this.getExistingSchema(this.handlers);
            if (schema == null) {
                schema = this.createSchema(locations);
                NamespaceHandlerRegistryImpl.this.cacheSchema(this.handlers, schema);
            }
            return schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Schema createSchema(Map<String, String> locations) throws IOException, SAXException {
            Loader loader = new Loader();
            try {
                URL url;
                loader.use(this.getClass().getResource("/org/osgi/service/blueprint/blueprint.xsd"), loader.getId("http://www.w3.org/2001/XMLSchema", "http://www.osgi.org/xmlns/blueprint/v1.0.0", null, null), "http://www.osgi.org/xmlns/blueprint/v1.0.0");
                loader.use(this.getClass().getResource("/org/apache/aries/blueprint/ext/impl/xml.xsd"), loader.getId("http://www.w3.org/2001/XMLSchema", "http://www.w3.org/XML/1998/namespace", null, null), "http://www.w3.org/XML/1998/namespace");
                for (URI schema : this.handlers.keySet()) {
                    String loc;
                    url = this.handlers.get(schema).getSchemaLocation(schema.toString());
                    if (url == null && locations != null && (loc = locations.get(schema.toString())) != null) {
                        url = this.handlers.get(schema).getSchemaLocation(loc);
                    }
                    if (url == null) {
                        LOGGER.warn("No URL is defined for schema " + schema + ". This schema will not be validated");
                        continue;
                    }
                    loader.use(url, loader.getId("http://www.w3.org/2001/XMLSchema", schema.toString(), null, null), schema.toString());
                }
                for (Object object : this.schemaMap.values()) {
                    url = this.bundle.getResource(object.toString());
                    if (url == null) {
                        LOGGER.warn("No URL is defined for schema " + object + ". This schema will not be validated");
                        continue;
                    }
                    loader.use(url, loader.getId("http://www.w3.org/2001/XMLSchema", object.toString(), null, null), object.toString());
                }
                SchemaFactory schemaFactory = NamespaceHandlerRegistryImpl.this.schemaFactory;
                synchronized (schemaFactory) {
                    NamespaceHandlerRegistryImpl.this.schemaFactory.setResourceResolver(loader);
                    Schema schema = NamespaceHandlerRegistryImpl.this.schemaFactory.newSchema(loader.getSources());
                    return schema;
                }
            }
            finally {
                loader.close();
            }
        }

        @Override
        public void addListener(NamespaceHandlerSet.Listener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(NamespaceHandlerSet.Listener listener) {
            this.listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            ArrayList arrayList = NamespaceHandlerRegistryImpl.this.sets;
            synchronized (arrayList) {
                NamespaceHandlerRegistryImpl.this.sets.remove(this);
            }
        }

        public void registerHandler(URI uri, NamespaceHandler handler) {
            if (this.namespaces.contains(uri) && this.handlers.get(uri) == null && this.findCompatibleNamespaceHandler(uri) != null) {
                for (NamespaceHandlerSet.Listener listener : this.listeners) {
                    try {
                        listener.namespaceHandlerRegistered(uri);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unexpected exception when notifying a NamespaceHandler listener", t);
                    }
                }
            }
        }

        public void unregisterHandler(URI uri, NamespaceHandler handler) {
            if (this.handlers.get(uri) == handler) {
                this.handlers.remove(uri);
                for (NamespaceHandlerSet.Listener listener : this.listeners) {
                    try {
                        listener.namespaceHandlerUnregistered(uri);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unexpected exception when notifying a NamespaceHandler listener", t);
                    }
                }
            }
        }

        private NamespaceHandler findCompatibleNamespaceHandler(URI ns) {
            Set candidates = (Set)NamespaceHandlerRegistryImpl.this.handlers.get(ns);
            if (candidates != null) {
                for (NamespaceHandler h : candidates) {
                    Set<Class> classes = h.getManagedClasses();
                    boolean compat = true;
                    if (classes != null) {
                        HashSet allClasses = new HashSet();
                        Iterator<Class<Object>> iterator = classes.iterator();
                        while (iterator.hasNext()) {
                            Class clazz;
                            for (Class c = clazz = iterator.next(); c != null; c = c.getSuperclass()) {
                                allClasses.add(c);
                                for (Class<?> i : c.getInterfaces()) {
                                    allClasses.add(i);
                                }
                            }
                        }
                        for (Class<Object> clazz : allClasses) {
                            try {
                                Class clb = this.bundle.loadClass(clazz.getName());
                                if (clb == clazz) continue;
                                compat = false;
                                break;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                            }
                        }
                    }
                    if (!compat) continue;
                    this.namespaces.add(ns);
                    this.handlers.put(ns, h);
                    return h;
                }
            }
            return null;
        }

        private class Loader
        implements LSResourceResolver,
        AutoCloseable {
            final List<StreamSource> sources = new ArrayList<StreamSource>();
            final Map<String, URL> loaded = new HashMap<String, URL>();
            final Map<String, String> namespaces = new HashMap<String, String>();

            private Loader() {
            }

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                URL url;
                String prevNamespace = baseURI != null ? this.namespaces.get(baseURI) : null;
                String id = namespaceURI != null && prevNamespace != null && namespaceURI.equals(prevNamespace) ? this.getId(type, namespaceURI, publicId, systemId) : this.getId(type, namespaceURI, publicId, null);
                if (this.loaded.containsKey(id)) {
                    return this.createLSInput(this.loaded.get(id), id, namespaceURI);
                }
                String loc = null;
                if (namespaceURI != null) {
                    loc = NamespaceHandlerSetImpl.this.schemaMap.getProperty(namespaceURI);
                }
                if (loc == null && publicId != null) {
                    loc = NamespaceHandlerSetImpl.this.schemaMap.getProperty(publicId);
                }
                if (loc == null && systemId != null) {
                    loc = NamespaceHandlerSetImpl.this.schemaMap.getProperty(systemId);
                }
                if (loc != null && (url = NamespaceHandlerSetImpl.this.bundle.getResource(loc)) != null) {
                    return this.createLSInput(url, id, namespaceURI);
                }
                String resolved = this.resolveIfRelative(systemId, baseURI);
                if (resolved != null) {
                    URL url2;
                    try {
                        url2 = new URL(resolved);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.createLSInput(url2, id, namespaceURI);
                }
                if (namespaceURI == null || !"http://www.w3.org/2001/XMLSchema".equals(type)) {
                    return null;
                }
                URI nsUri = URI.create(namespaceURI);
                String rid = systemId != null ? systemId : namespaceURI;
                NamespaceHandler h = NamespaceHandlerSetImpl.this.getNamespaceHandler(nsUri);
                if (h != null) {
                    URL url3 = h.getSchemaLocation(rid);
                    if (this.isCorrectUrl(url3)) {
                        return this.createLSInput(url3, id, namespaceURI);
                    }
                } else {
                    Object url3 = NamespaceHandlerSetImpl.this.handlers.values().iterator();
                    while (url3.hasNext()) {
                        NamespaceHandler hd = (NamespaceHandler)url3.next();
                        URL url4 = hd.getSchemaLocation(rid);
                        if (!this.isCorrectUrl(url4)) continue;
                        return this.createLSInput(url4, id, namespaceURI);
                    }
                    LOGGER.warn("Dynamically adding namespace handler {} to bundle {}/{}", new Object[]{nsUri, NamespaceHandlerSetImpl.this.bundle.getSymbolicName(), NamespaceHandlerSetImpl.this.bundle.getVersion()});
                    h = NamespaceHandlerSetImpl.this.findCompatibleNamespaceHandler(nsUri);
                    if (h != null && this.isCorrectUrl((URL)(url3 = h.getSchemaLocation(rid)))) {
                        return this.createLSInput((URL)url3, id, namespaceURI);
                    }
                }
                return null;
            }

            public String getId(String type, String namespaceURI, String publicId, String systemId) {
                return type + "|" + namespaceURI + "|" + publicId + "|" + systemId;
            }

            public StreamSource use(URL resource, String id, String namespace) throws IOException {
                String url = resource.toExternalForm();
                StreamSource ss = new StreamSource(resource.openStream(), url);
                this.sources.add(ss);
                this.loaded.put(id, resource);
                this.namespaces.put(url, namespace);
                return ss;
            }

            @Override
            public void close() {
                for (StreamSource source : this.sources) {
                    NamespaceHandlerRegistryImpl.closeQuietly(source.getInputStream());
                }
            }

            public Source[] getSources() {
                return this.sources.toArray(new Source[this.sources.size()]);
            }

            private boolean isCorrectUrl(URL url) {
                return url != null && !this.loaded.values().contains(url);
            }

            private String resolveIfRelative(String systemId, String baseURI) {
                URI sId;
                if (baseURI != null && systemId != null && !(sId = URI.create(systemId)).isAbsolute()) {
                    return URI.create(baseURI).resolve(sId).toString();
                }
                return null;
            }

            private LSInput createLSInput(URL url, String id, String namespace) {
                try {
                    return new SourceLSInput(this.use(url, id, namespace));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class SourceLSInput
    implements LSInput {
        private final StreamSource source;

        public SourceLSInput(StreamSource source) {
            this.source = source;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return this.source.getInputStream();
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.source.getSystemId();
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

