/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="jaas", name="realm-manage", description="Manage users and roles of a JAAS Realm")
public class ManageRealmCommand
extends JaasCommandSupport {
    @Option(name="--realm", description="JAAS Realm", required=false, multiValued=false)
    String realmName;
    @Option(name="--index", description="Realm Index", required=false, multiValued=false)
    int index;
    @Option(name="--module", description="JAAS Login Module Class Name", required=false, multiValued=false)
    String moduleName;
    @Option(name="-f", aliases={"--force"}, description="Force the management of this realm, even if another one was under management", required=false, multiValued=false)
    boolean force;
    @Option(name="-h", aliases={"--hidden"}, description="Manage hidden realms", required=false, multiValued=false)
    boolean hidden;

    @Override
    protected Object doExecute() throws Exception {
        if (this.realmName == null && this.index <= 0) {
            System.err.println("A valid realm or the realm index need to be specified");
            return null;
        }
        JaasRealm oldRealm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry oldEntry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (oldRealm != null && !oldRealm.getName().equals(this.realmName) && !this.force) {
            System.err.println("Another JAAS Realm is being edited. Cancel/update first, or use the --force option.");
        } else if (oldEntry != null && !oldEntry.getLoginModuleName().equals(this.moduleName) && !this.force) {
            System.err.println("Another JAAS Login Module is being edited. Cancel/update first, or use the --force option.");
        } else {
            AppConfigurationEntry entry;
            JaasRealm realm;
            block18: {
                List<JaasRealm> realms;
                realm = null;
                entry = null;
                if (this.index > 0) {
                    realms = this.getRealms(this.hidden);
                    if (realms != null && realms.size() > 0) {
                        int i = 1;
                        for (JaasRealm r : realms) {
                            AppConfigurationEntry[] entries = r.getEntries();
                            if (entries == null) continue;
                            for (int j = 0; j < entries.length; ++j) {
                                if (i == this.index) {
                                    realm = r;
                                    entry = entries[j];
                                    break block18;
                                }
                                ++i;
                            }
                        }
                    }
                } else {
                    realms = this.getRealms();
                    if (realms != null && realms.size() > 0) {
                        for (JaasRealm r : realms) {
                            AppConfigurationEntry[] entries;
                            if (!r.getName().equals(this.realmName) || (entries = (realm = r).getEntries()) == null) continue;
                            for (AppConfigurationEntry e : entries) {
                                String moduleClass = (String)e.getOptions().get("org.apache.karaf.jaas.module");
                                if (this.moduleName == null) {
                                    entry = e;
                                    break;
                                }
                                if (!this.moduleName.equals(e.getLoginModuleName()) && !this.moduleName.equals(moduleClass)) continue;
                                entry = e;
                                break;
                            }
                            if (entry == null) continue;
                            break;
                        }
                    }
                }
            }
            if (realm == null) {
                System.err.println("JAAS realm has not been found.");
                return null;
            }
            if (entry == null) {
                System.err.println("JAAS module has not been found.");
                return null;
            }
            LinkedList commands = null;
            commands = (LinkedList)this.session.get("JaasCommand.COMMANDS");
            if (commands == null) {
                commands = new LinkedList();
            }
            this.session.put("JaasCommand.REALM", realm);
            this.session.put("JaasCommand.ENTRY", entry);
            this.session.put("JaasCommand.COMMANDS", commands);
        }
        return null;
    }

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }
}

