/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellUtil.class);

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    public static String getUnderlineString(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getValueString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof Collection) {
            Object[] array = ((Collection)obj).toArray();
            return ShellUtil.getValueString(array);
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(ShellUtil.getValueString(array[i]));
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }

    public static boolean isASystemBundle(BundleContext bundleContext, Bundle bundle) {
        int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
        int sbsl = 49;
        String sbslProp = bundleContext.getProperty("karaf.systemBundlesStartLevel");
        if (sbslProp != null) {
            try {
                sbsl = Integer.valueOf(sbslProp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return level <= sbsl;
    }

    public static boolean getBoolean(Session session, String name) {
        Object s = session.get(name);
        if (s == null) {
            s = System.getProperty(name);
        }
        if (s == null) {
            return false;
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return Boolean.parseBoolean(s.toString());
    }

    public static void logException(Session session, Throwable t) {
        block13: {
            try {
                session.put("karaf.lastException", t);
                String name = t.getClass().getSimpleName();
                if ("CommandNotFoundException".equals(name)) {
                    LOGGER.debug("Unknown command entered", t);
                } else if ("CommandException".equals(name)) {
                    LOGGER.debug("Command exception (Undefined option, ...)", t);
                } else {
                    LOGGER.error("Exception caught while executing command", t);
                }
                String pst = ShellUtil.getPrintStackTraces(session);
                if ("always".equals(pst)) {
                    session.getConsole().print(SimpleAnsi.COLOR_RED);
                    t.printStackTrace(session.getConsole());
                    session.getConsole().print(SimpleAnsi.COLOR_DEFAULT);
                    break block13;
                }
                if ("CommandNotFoundException".equals(name)) {
                    String str = SimpleAnsi.COLOR_RED + "Command not found: " + SimpleAnsi.INTENSITY_BOLD + t.getClass().getMethod("getCommand", new Class[0]).invoke((Object)t, new Object[0]) + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT;
                    session.getConsole().println(str);
                    break block13;
                }
                if ("CommandException".equals(name)) {
                    String str;
                    try {
                        str = (String)t.getClass().getMethod("getNiceHelp", new Class[0]).invoke((Object)t, new Object[0]);
                    }
                    catch (Throwable ignore) {
                        str = SimpleAnsi.COLOR_RED + t.getMessage() + SimpleAnsi.COLOR_DEFAULT;
                    }
                    session.getConsole().println(str);
                    break block13;
                }
                if ("execution".equals(pst)) {
                    session.getConsole().print(SimpleAnsi.COLOR_RED);
                    t.printStackTrace(session.getConsole());
                    session.getConsole().print(SimpleAnsi.COLOR_DEFAULT);
                } else {
                    String str = SimpleAnsi.COLOR_RED + "Error executing command: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getName()) + SimpleAnsi.COLOR_DEFAULT;
                    session.getConsole().println(str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String getPrintStackTraces(Session session) {
        Object pst = session.get("karaf.printStackTraces");
        if (pst == null) {
            pst = System.getProperty("karaf.printStackTraces");
        }
        if (pst == null) {
            return "never";
        }
        if (pst instanceof Boolean) {
            return (Boolean)pst != false ? "always" : "never";
        }
        return pst.toString().toLowerCase();
    }

    public static String getCurrentUserName() {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject != null && subject.getPrincipals(UserPrincipal.class).iterator().hasNext()) {
            return subject.getPrincipals(UserPrincipal.class).iterator().next().getName();
        }
        return null;
    }
}

