/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.event.command;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import org.osgi.service.event.Event;

public class EventPrinter
implements Consumer<Event> {
    private PrintStream out;
    private boolean verbose;

    public EventPrinter(PrintStream out, boolean verbose) {
        this.out = out;
        this.verbose = verbose;
    }

    @Override
    public void accept(Event event) {
        this.out.println(this.getTimeStamp(event) + " - " + event.getTopic());
        if (this.verbose) {
            for (String key : event.getPropertyNames()) {
                if (key.equals("event.topics") || key.equals("timestamp")) continue;
                this.out.println(key + ": " + String.valueOf(this.getPrintValue(event, key)));
            }
            this.out.println();
            this.out.flush();
        }
    }

    private String getTimeStamp(Event event) {
        Long ts = (Long)event.getProperty("timestamp");
        if (ts == null) {
            return "0000-00-00 00:00:00";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date(ts));
    }

    private Object getPrintValue(Event event, String key) {
        Object value = event.getProperty(key);
        if (value.getClass().isArray()) {
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }
}

