/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.CacheHeaderContentStream;
import org.apache.chemistry.opencmis.commons.data.ContentLengthContentStream;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.LastModifiedContentStream;
import org.apache.chemistry.opencmis.commons.data.RedirectingContentStream;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.CmisEnumHelper;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ProgressControlCmisService;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.ServiceCall;

public abstract class AbstractServiceCall
implements ServiceCall {
    public String getStringParameter(HttpServletRequest request, String name) {
        return HttpUtils.getStringParameter(request, name);
    }

    public boolean getBooleanParameter(HttpServletRequest request, String name, boolean def) {
        String value = this.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return def;
        }
        return Boolean.valueOf(value);
    }

    public Boolean getBooleanParameter(HttpServletRequest request, String name) {
        String value = this.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public BigInteger getBigIntegerParameter(HttpServletRequest request, String name, long def) {
        BigInteger result = this.getBigIntegerParameter(request, name);
        if (result == null) {
            result = BigInteger.valueOf(def);
        }
        return result;
    }

    public BigInteger getBigIntegerParameter(HttpServletRequest request, String name) {
        String value = this.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new CmisInvalidArgumentException("Invalid parameter '" + name + "'!", (Throwable)e);
        }
    }

    public DateTimeFormat getDateTimeFormatParameter(HttpServletRequest request) {
        String s = this.getStringParameter(request, "dateTimeFormat");
        if (s == null) {
            return DateTimeFormat.SIMPLE;
        }
        try {
            return DateTimeFormat.fromValue((String)s.trim().toLowerCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new CmisInvalidArgumentException("Invalid value for parameter dateTimeFormat!");
        }
    }

    public <T extends Enum<T>> T getEnumParameter(HttpServletRequest request, String name, Class<T> clazz) {
        return (T)CmisEnumHelper.fromValue((String)this.getStringParameter(request, name), clazz);
    }

    public boolean sendContentStreamHeaders(ContentStream content, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GregorianCalendar lastModified;
        assert (request != null);
        assert (response != null);
        if (content instanceof LastModifiedContentStream && (lastModified = ((LastModifiedContentStream)content).getLastModified()) != null) {
            long modifiedSinceSecs;
            long lastModifiedSecs = (long)Math.floor((double)lastModified.getTimeInMillis() / 1000.0);
            Date modifiedSince = DateTimeHelper.parseHttpDateTime((String)request.getHeader("If-Modified-Since"));
            if (modifiedSince != null && (modifiedSinceSecs = (long)Math.floor((double)modifiedSince.getTime() / 1000.0)) >= lastModifiedSecs) {
                content.getStream().close();
                response.setStatus(304);
                response.setContentLength(0);
                return true;
            }
            response.setHeader("Last-Modified", DateTimeHelper.formatHttpDateTime((long)(lastModifiedSecs * 1000L)));
        }
        if (content instanceof RedirectingContentStream) {
            int status;
            RedirectingContentStream rcs = (RedirectingContentStream)content;
            if (content.getStream() != null) {
                IOUtils.closeQuietly((Closeable)content.getStream());
            }
            if (rcs.getLocation() != null) {
                response.setHeader("Location", rcs.getLocation());
            }
            if ((status = rcs.getStatus()) < 300 || status >= 400) {
                status = 307;
            }
            response.setStatus(status);
            return true;
        }
        if (content instanceof CacheHeaderContentStream) {
            CacheHeaderContentStream chcs = (CacheHeaderContentStream)content;
            if (chcs.getETag() != null) {
                String etag = request.getHeader("If-None-Match");
                if (etag != null && !etag.equals("*")) {
                    if (etag.length() > 2 && etag.charAt(0) == '\"' && etag.endsWith("\"")) {
                        etag = etag.substring(1, etag.length() - 1);
                    }
                    if (chcs.getETag().equals(etag)) {
                        content.getStream().close();
                        response.setStatus(304);
                        response.setContentLength(0);
                        return true;
                    }
                }
                response.setHeader("ETag", "\"" + chcs.getETag() + "\"");
            }
            if (chcs.getCacheControl() != null) {
                response.setHeader("Cache-Control", chcs.getCacheControl());
            }
            if (chcs.getExpires() != null) {
                response.setHeader("Expires", DateTimeHelper.formatHttpDateTime((GregorianCalendar)chcs.getExpires()));
            }
        }
        if (content instanceof ContentLengthContentStream && content.getBigLength() != null && content.getBigLength().signum() >= 0) {
            response.setHeader("Content-Length", content.getBigLength().toString());
        }
        return false;
    }

    protected boolean stopBeforeService(CmisService service) {
        if (!(service instanceof ProgressControlCmisService)) {
            return false;
        }
        return ((ProgressControlCmisService)service).beforeServiceCall() == ProgressControlCmisService.Progress.STOP;
    }

    protected boolean stopAfterService(CmisService service) {
        if (!(service instanceof ProgressControlCmisService)) {
            return false;
        }
        return ((ProgressControlCmisService)service).afterServiceCall() == ProgressControlCmisService.Progress.STOP;
    }
}

