/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.mvndaemon.mvnd.common.BufferCaster;
import org.mvndaemon.mvnd.common.DaemonException;
import org.mvndaemon.mvnd.common.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonConnection
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonConnection.class);
    private final SocketChannel socket;
    private final DataInputStream input;
    private final DataOutputStream output;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;

    public DaemonConnection(SocketChannel socket) throws IOException {
        this.socket = socket;
        try {
            socket.configureBlocking(false);
            this.output = new DataOutputStream(new SocketOutputStream(socket));
            this.input = new DataInputStream(new SocketInputStream(socket));
        }
        catch (IOException e) {
            throw new DaemonException.InterruptedException(e);
        }
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
    }

    public String toString() {
        return "socket connection from " + this.localAddress + " to " + this.remoteAddress;
    }

    public Message receive() throws DaemonException.MessageIOException {
        try {
            return Message.read(this.input);
        }
        catch (EOFException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Discarding EOFException: {}", (Object)e.toString(), (Object)e);
            }
            return null;
        }
        catch (IOException e) {
            throw new DaemonException.RecoverableMessageIOException(String.format("Could not read message from '%s'.", this.remoteAddress), e);
        }
        catch (Throwable e) {
            throw new DaemonException.MessageIOException(String.format("Could not read message from '%s'.", this.remoteAddress), e);
        }
    }

    private static boolean isEndOfStream(Exception e) {
        if (e instanceof EOFException) {
            return true;
        }
        if (e instanceof IOException) {
            if (Objects.equals(e.getMessage(), "An existing connection was forcibly closed by the remote host")) {
                return true;
            }
            if (Objects.equals(e.getMessage(), "An established connection was aborted by the software in your host machine")) {
                return true;
            }
            if (Objects.equals(e.getMessage(), "Connection reset by peer")) {
                return true;
            }
            if (Objects.equals(e.getMessage(), "Connection reset")) {
                return true;
            }
        }
        return false;
    }

    public void dispatch(Message message) throws DaemonException.MessageIOException {
        try {
            message.write(this.output);
            this.output.flush();
        }
        catch (IOException e) {
            throw new DaemonException.RecoverableMessageIOException(String.format("Could not write message %s to '%s'.", message, this.remoteAddress), e);
        }
        catch (Throwable e) {
            throw new DaemonException.MessageIOException(String.format("Could not write message %s to '%s'.", message, this.remoteAddress), e);
        }
    }

    public void flush() throws DaemonException.MessageIOException {
        try {
            this.output.flush();
        }
        catch (Throwable e) {
            throw new DaemonException.MessageIOException(String.format("Could not write '%s'.", this.remoteAddress), e);
        }
    }

    @Override
    public void close() {
        Throwable failure = null;
        List<Closeable> elements = Arrays.asList(this::flush, this.input, this.output, this.socket);
        for (Closeable element : elements) {
            try {
                element.close();
            }
            catch (Throwable throwable) {
                if (failure == null) {
                    failure = throwable;
                    continue;
                }
                if (Thread.currentThread().isInterrupted()) continue;
                LOGGER.error("Could not stop {}.", (Object)element, (Object)throwable);
            }
        }
        if (failure != null) {
            throw new DaemonException(failure);
        }
    }

    private static class SocketOutputStream
    extends OutputStream {
        private static final int RETRIES_WHEN_BUFFER_FULL = 2;
        private Selector selector;
        private final SocketChannel socket;
        private final ByteBuffer buffer;
        private final byte[] writeBuffer = new byte[1];

        public SocketOutputStream(SocketChannel socket) throws IOException {
            this.socket = socket;
            this.buffer = ByteBuffer.allocateDirect(32768);
        }

        @Override
        public void write(int b) throws IOException {
            this.writeBuffer[0] = (byte)b;
            this.write(this.writeBuffer);
        }

        @Override
        public void write(byte[] src, int offset, int max) throws IOException {
            int remaining = max;
            int currentPos = offset;
            while (remaining > 0) {
                int count = Math.min(remaining, this.buffer.remaining());
                if (count > 0) {
                    this.buffer.put(src, currentPos, count);
                    remaining -= count;
                    currentPos += count;
                }
                while (this.buffer.remaining() == 0) {
                    this.writeBufferToChannel();
                }
            }
        }

        @Override
        public void flush() throws IOException {
            while (this.buffer.position() > 0) {
                this.writeBufferToChannel();
            }
        }

        private void writeBufferToChannel() throws IOException {
            BufferCaster.cast(this.buffer).flip();
            int count = this.writeWithNonBlockingRetry();
            if (count == 0) {
                this.waitForWriteBufferToDrain();
            }
            this.buffer.compact();
        }

        private int writeWithNonBlockingRetry() throws IOException {
            int count = 0;
            int retryCount = 0;
            while (count == 0 && retryCount++ < 2) {
                count = this.socket.write(this.buffer);
                if (count < 0) {
                    throw new EOFException();
                }
                if (count != 0) continue;
                Thread.yield();
            }
            return count;
        }

        private void waitForWriteBufferToDrain() throws IOException {
            if (this.selector == null) {
                this.selector = Selector.open();
            }
            SelectionKey key = this.socket.register(this.selector, 4);
            this.selector.select();
            key.cancel();
            this.selector.selectNow();
        }

        @Override
        public void close() throws IOException {
            if (this.selector != null) {
                this.selector.close();
                this.selector = null;
            }
        }
    }

    private static class SocketInputStream
    extends InputStream {
        private final Selector selector;
        private final ByteBuffer buffer;
        private final SocketChannel socket;
        private final byte[] readBuffer = new byte[1];

        public SocketInputStream(SocketChannel socket) throws IOException {
            this.socket = socket;
            this.selector = Selector.open();
            socket.register(this.selector, 1);
            this.buffer = ByteBuffer.allocateDirect(4096);
            BufferCaster.cast(this.buffer).limit(0);
        }

        @Override
        public int read() throws IOException {
            int nread = this.read(this.readBuffer, 0, 1);
            if (nread <= 0) {
                return nread;
            }
            return this.readBuffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] dest, int offset, int max) throws IOException {
            if (max == 0) {
                return 0;
            }
            if (this.buffer.remaining() == 0) {
                int nread;
                try {
                    this.selector.select();
                }
                catch (ClosedSelectorException e) {
                    return -1;
                }
                if (!this.selector.isOpen()) {
                    return -1;
                }
                BufferCaster.cast(this.buffer).clear();
                try {
                    nread = this.socket.read(this.buffer);
                }
                catch (IOException e) {
                    if (DaemonConnection.isEndOfStream(e)) {
                        BufferCaster.cast(this.buffer).position(0);
                        BufferCaster.cast(this.buffer).limit(0);
                        return -1;
                    }
                    throw e;
                }
                BufferCaster.cast(this.buffer).flip();
                if (nread < 0) {
                    return -1;
                }
            }
            int count = Math.min(this.buffer.remaining(), max);
            this.buffer.get(dest, offset, count);
            return count;
        }

        @Override
        public void close() throws IOException {
            this.selector.close();
        }
    }
}

