/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.logging.api.LogLevelRecorder;
import org.slf4j.event.Level;

public class DefaultLogLevelRecorder
implements LogLevelRecorder {
    private LogLevelRecorder.Level maxAllowed;
    private final AtomicReference<LogLevelRecorder.Level> maxReached = new AtomicReference<LogLevelRecorder.Level>(LogLevelRecorder.Level.DEBUG);

    @Override
    public boolean hasReachedMaxLevel() {
        return this.maxReached.get().ordinal() > this.maxAllowed.ordinal();
    }

    @Override
    public LogLevelRecorder.Level getMaxLevelReached() {
        return this.maxReached.get();
    }

    @Override
    public LogLevelRecorder.Level getMaxLevelAllowed() {
        return this.maxAllowed;
    }

    @Override
    public void setMaxLevelAllowed(LogLevelRecorder.Level level) {
        this.maxAllowed = level;
    }

    @Override
    public void reset() {
        this.maxAllowed = null;
        this.maxReached.set(LogLevelRecorder.Level.DEBUG);
    }

    public void record(Level logLevel) {
        LogLevelRecorder.Level r;
        LogLevelRecorder.Level level = switch (logLevel) {
            default -> throw new IncompatibleClassChangeError();
            case Level.TRACE, Level.DEBUG -> LogLevelRecorder.Level.DEBUG;
            case Level.INFO -> LogLevelRecorder.Level.INFO;
            case Level.WARN -> LogLevelRecorder.Level.WARN;
            case Level.ERROR -> LogLevelRecorder.Level.ERROR;
        };
        do {
            r = this.maxReached.get();
        } while (level.ordinal() > r.ordinal() && !this.maxReached.compareAndSet(r, level));
    }

    public boolean metThreshold() {
        return this.maxAllowed != null && this.maxReached.get().ordinal() >= this.maxAllowed.ordinal();
    }
}

