/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import org.apache.maven.api.services.BuilderProblem;

class DefaultBuilderProblem
implements BuilderProblem {
    final String source;
    final int lineNumber;
    final int columnNumber;
    final Exception exception;
    final String message;
    final BuilderProblem.Severity severity;

    DefaultBuilderProblem(String source, int lineNumber, int columnNumber, Exception exception, String message, BuilderProblem.Severity severity) {
        this.source = source;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.exception = exception;
        this.message = message;
        this.severity = severity;
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public BuilderProblem.Severity getSeverity() {
        return this.severity;
    }

    public String getLocation() {
        StringBuilder buffer = new StringBuilder(256);
        if (this.getSource() != null && !this.getSource().isEmpty()) {
            buffer.append(this.getSource());
        }
        if (this.getLineNumber() > 0) {
            if (!buffer.isEmpty()) {
                buffer.append(", ");
            }
            buffer.append("line ").append(this.getLineNumber());
        }
        if (this.getColumnNumber() > 0) {
            if (!buffer.isEmpty()) {
                buffer.append(", ");
            }
            buffer.append("column ").append(this.getColumnNumber());
        }
        return buffer.toString();
    }

    public String toString() {
        String location;
        String msg;
        StringBuilder buffer = new StringBuilder(128);
        buffer.append('[').append(this.severity).append("]");
        String string = this.message != null ? this.message : (msg = this.exception != null ? this.exception.getMessage() : null);
        if (msg != null && !msg.isEmpty()) {
            buffer.append(" ").append(msg);
        }
        if (!(location = this.getLocation()).isEmpty()) {
            buffer.append(" @ ").append(location);
        }
        return buffer.toString();
    }
}

