/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.classfile;

import java.io.IOException;
import jpt.sun.tools.classfile.Attribute;
import jpt.sun.tools.classfile.ClassReader;
import jpt.sun.tools.classfile.ConstantPool;
import jpt.sun.tools.classfile.ConstantPoolException;

public class CharacterRangeTable_attribute
extends Attribute {
    public static final int CRT_STATEMENT = 1;
    public static final int CRT_BLOCK = 2;
    public static final int CRT_ASSIGNMENT = 4;
    public static final int CRT_FLOW_CONTROLLER = 8;
    public static final int CRT_FLOW_TARGET = 16;
    public static final int CRT_INVOKE = 32;
    public static final int CRT_CREATE = 64;
    public static final int CRT_BRANCH_TRUE = 128;
    public static final int CRT_BRANCH_FALSE = 256;
    public final Entry[] character_range_table;

    CharacterRangeTable_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        int character_range_table_length = cr.readUnsignedShort();
        this.character_range_table = new Entry[character_range_table_length];
        for (int i = 0; i < character_range_table_length; ++i) {
            this.character_range_table[i] = new Entry(cr);
        }
    }

    public CharacterRangeTable_attribute(ConstantPool constant_pool, Entry[] character_range_table) throws ConstantPoolException {
        this(constant_pool.getUTF8Index("CharacterRangeTable"), character_range_table);
    }

    public CharacterRangeTable_attribute(int name_index, Entry[] character_range_table) {
        super(name_index, 2 + character_range_table.length * Entry.length());
        this.character_range_table = character_range_table;
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitCharacterRangeTable(this, data);
    }

    public static class Entry {
        public final int start_pc;
        public final int end_pc;
        public final int character_range_start;
        public final int character_range_end;
        public final int flags;

        Entry(ClassReader cr) throws IOException {
            this.start_pc = cr.readUnsignedShort();
            this.end_pc = cr.readUnsignedShort();
            this.character_range_start = cr.readInt();
            this.character_range_end = cr.readInt();
            this.flags = cr.readUnsignedShort();
        }

        public static int length() {
            return 14;
        }
    }
}

