/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.annotations;

import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.ee11.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.ee11.servlet.ServletMapping;
import org.eclipse.jetty.ee11.servlet.security.ConstraintAware;
import org.eclipse.jetty.ee11.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee11.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.security.SecurityHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletSecurityAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServletSecurityAnnotationHandler.class);

    public ServletSecurityAnnotationHandler(WebAppContext wac) {
        super(false, wac);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        ArrayList constraintMappings;
        SecurityHandler securityHandler = this._context.getSecurityHandler();
        if (!(securityHandler instanceof ConstraintAware)) {
            LOG.warn("SecurityHandler not ConstraintAware, skipping security annotation processing");
            return;
        }
        ConstraintAware securityHandler2 = (ConstraintAware)securityHandler;
        ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
        if (servletSecurity == null) {
            return;
        }
        List<ServletMapping> servletMappings = this.getServletMappings(clazz.getCanonicalName());
        if (this.constraintsExist(servletMappings, constraintMappings = ((ConstraintAware)this._context.getSecurityHandler()).getConstraintMappings())) {
            LOG.warn("Constraints already defined for {}, skipping ServletSecurity annotation", (Object)clazz.getName());
            return;
        }
        constraintMappings = new ArrayList();
        ServletSecurityElement securityElement = new ServletSecurityElement(servletSecurity);
        for (ServletMapping sm : servletMappings) {
            for (String url : sm.getPathSpecs()) {
                this._context.getMetaData().setOrigin("constraint.url." + url, (Annotation)servletSecurity, clazz);
                constraintMappings.addAll(ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)clazz.getName(), (String)url, (ServletSecurityElement)securityElement));
            }
        }
        constraintMappings.forEach(arg_0 -> ((ConstraintAware)securityHandler2).addConstraintMapping(arg_0));
        securityHandler2.checkPathsWithUncoveredHttpMethods();
    }

    protected List<ServletMapping> getServletMappings(String className) {
        ServletMapping[] mappings;
        ArrayList<ServletMapping> results = new ArrayList<ServletMapping>();
        for (ServletMapping mapping : mappings = this._context.getServletHandler().getServletMappings()) {
            ServletHolder holder = this._context.getServletHandler().getServlet(mapping.getServletName());
            if (holder.getClassName() == null || !holder.getClassName().equals(className)) continue;
            results.add(mapping);
        }
        return results;
    }

    protected boolean constraintsExist(List<ServletMapping> servletMappings, List<ConstraintMapping> constraintMappings) {
        boolean exists = false;
        for (ServletMapping mapping : servletMappings) {
            String[] pathSpecs = mapping.getPathSpecs();
            if (pathSpecs == null) continue;
            block1: for (int i = 0; constraintMappings != null && i < constraintMappings.size() && !exists; ++i) {
                for (String pathSpec : pathSpecs) {
                    if (!pathSpec.equals(constraintMappings.get(i).getPathSpec())) continue;
                    exists = true;
                    continue block1;
                }
            }
        }
        return exists;
    }
}

