/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.WindowImpl;
import org.springframework.data.util.Streamable;

public interface Window<T>
extends Streamable<T> {
    public static <T> Window<T> from(List<T> items, IntFunction<? extends ScrollPosition> positionFunction) {
        return new WindowImpl<T>(items, positionFunction, false);
    }

    public static <T> Window<T> from(List<T> items, IntFunction<? extends ScrollPosition> positionFunction, boolean hasNext) {
        return new WindowImpl<T>(items, positionFunction, hasNext);
    }

    public int size();

    @Override
    public boolean isEmpty();

    public List<T> getContent();

    default public boolean isLast() {
        return !this.hasNext();
    }

    public boolean hasNext();

    default public boolean hasPosition(int index) {
        try {
            this.positionAt(index);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public ScrollPosition positionAt(int var1);

    default public ScrollPosition positionAt(T object) {
        int index = this.getContent().indexOf(object);
        if (index == -1) {
            throw new NoSuchElementException();
        }
        return this.positionAt(index);
    }

    @Override
    public <U> Window<U> map(Function<? super T, ? extends U> var1);
}

