/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;

public final class AuthorizationManagers {
    @SafeVarargs
    public static <T> AuthorizationManager<T> anyOf(AuthorizationManager<T> ... managers) {
        return AuthorizationManagers.anyOf(new AuthorizationDecision(false), managers);
    }

    @SafeVarargs
    public static <T> AuthorizationManager<T> anyOf(AuthorizationDecision allAbstainDefaultDecision, AuthorizationManager<T> ... managers) {
        return (authentication, object) -> {
            ArrayList<AuthorizationResult> results = new ArrayList<AuthorizationResult>();
            for (AuthorizationManager manager : managers) {
                AuthorizationResult result = manager.authorize(authentication, object);
                if (result == null) continue;
                if (result.isGranted()) {
                    return result;
                }
                results.add(result);
            }
            if (results.isEmpty()) {
                return allAbstainDefaultDecision;
            }
            return new CompositeAuthorizationDecision(false, results);
        };
    }

    @SafeVarargs
    public static <T> AuthorizationManager<T> allOf(AuthorizationManager<T> ... managers) {
        return AuthorizationManagers.allOf(new AuthorizationDecision(true), managers);
    }

    @SafeVarargs
    public static <T> AuthorizationManager<T> allOf(AuthorizationDecision allAbstainDefaultDecision, AuthorizationManager<T> ... managers) {
        return (authentication, object) -> {
            ArrayList<AuthorizationResult> results = new ArrayList<AuthorizationResult>();
            for (AuthorizationManager manager : managers) {
                AuthorizationResult result = manager.authorize(authentication, object);
                if (result == null) continue;
                if (!result.isGranted()) {
                    return result;
                }
                results.add(result);
            }
            if (results.isEmpty()) {
                return allAbstainDefaultDecision;
            }
            return new CompositeAuthorizationDecision(true, results);
        };
    }

    public static <T> AuthorizationManager<T> not(AuthorizationManager<T> manager) {
        return (authentication, object) -> {
            AuthorizationResult result = manager.authorize(authentication, object);
            if (result == null) {
                return null;
            }
            return new NotAuthorizationDecision(result);
        };
    }

    private AuthorizationManagers() {
    }

    private static interface AuthorizationManagerCheckAdapter<T>
    extends AuthorizationManager<T> {
        @Override
        public AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> var1, T var2);
    }

    private static final class NotAuthorizationDecision
    extends AuthorizationDecision {
        private final AuthorizationResult result;

        private NotAuthorizationDecision(AuthorizationResult result) {
            super(!result.isGranted());
            this.result = result;
        }

        @Override
        public String toString() {
            return "NotAuthorizationDecision [result=" + String.valueOf(this.result) + "]";
        }
    }

    private static final class CompositeAuthorizationDecision
    extends AuthorizationDecision {
        private final List<AuthorizationResult> results;

        private CompositeAuthorizationDecision(boolean granted, List<AuthorizationResult> results) {
            super(granted);
            this.results = results;
        }

        @Override
        public String toString() {
            return "CompositeAuthorizationDecision [results=" + String.valueOf(this.results) + "]";
        }
    }
}

