/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataInternalServerErrorException;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.rest.MERGE;
import org.apache.olingo.odata2.core.rest.ODataExceptionWrapper;
import org.apache.olingo.odata2.core.rest.PATCH;
import org.apache.olingo.odata2.core.rest.RestUtil;
import org.apache.olingo.odata2.core.rest.SubLocatorParameter;

public final class ODataSubLocator {
    private ODataServiceFactory serviceFactory;
    private ODataRequest request;
    private HttpServletRequest httpRequest;

    @GET
    public Response handleGet() throws ODataException {
        return this.handle(ODataHttpMethod.GET);
    }

    @PUT
    public Response handlePut() throws ODataException {
        return this.handle(ODataHttpMethod.PUT);
    }

    @PATCH
    public Response handlePatch() throws ODataException {
        return this.handle(ODataHttpMethod.PATCH);
    }

    @MERGE
    public Response handleMerge() throws ODataException {
        return this.handle(ODataHttpMethod.MERGE);
    }

    @DELETE
    public Response handleDelete() throws ODataException {
        return this.handle(ODataHttpMethod.DELETE);
    }

    @POST
    public Response handlePost(@HeaderParam(value="X-HTTP-Method") String xHttpMethod, @HeaderParam(value="X-HTTP-Method-Override") String xHttpMethodOverride) throws ODataException {
        if (xHttpMethod == null && xHttpMethodOverride != null) {
            return this.handleMethodOverride(xHttpMethodOverride);
        }
        if (xHttpMethod == null) {
            return this.handle(ODataHttpMethod.POST);
        }
        if ("MERGE".equals(xHttpMethod)) {
            return this.handle(ODataHttpMethod.MERGE);
        }
        if ("PATCH".equals(xHttpMethod)) {
            return this.handle(ODataHttpMethod.PATCH);
        }
        if ("DELETE".equals(xHttpMethod)) {
            return this.handle(ODataHttpMethod.DELETE);
        }
        if ("PUT".equals(xHttpMethod)) {
            return this.handle(ODataHttpMethod.PUT);
        }
        if ("GET".equals(xHttpMethod)) {
            return this.handle(ODataHttpMethod.GET);
        }
        if ("POST".equals(xHttpMethod)) {
            return this.handle(ODataHttpMethod.POST);
        }
        if ("HEAD".equals(xHttpMethod)) {
            return this.handleHead();
        }
        if ("OPTIONS".equals(xHttpMethod)) {
            return this.handleOptions();
        }
        return this.returnNotImplementedResponse(ODataNotImplementedException.TUNNELING);
    }

    private Response handleMethodOverride(String xHttpMethodOverride) throws ODataException {
        switch (xHttpMethodOverride.toUpperCase()) {
            case "OPTIONS": {
                return this.handleOptions();
            }
            case "GET": {
                return this.handleGet();
            }
            case "DELETE": {
                return this.handleDelete();
            }
            case "HEAD": {
                return this.handleHead();
            }
            case "MERGE": {
                return this.handleMerge();
            }
            case "PATCH": {
                return this.handlePatch();
            }
            case "POST": {
                return this.handle(ODataHttpMethod.POST);
            }
            case "PUT": {
                return this.handlePut();
            }
        }
        return this.returnNotImplementedResponse(ODataNotImplementedException.COMMON);
    }

    private Response returnNotImplementedResponse(MessageReference messageReference) {
        return this.returnException((ODataMessageException)new ODataNotImplementedException(messageReference));
    }

    private Response returnException(ODataMessageException messageException) {
        ODataContextImpl context = new ODataContextImpl(this.request, this.serviceFactory);
        context.setRequest(this.request);
        context.setAcceptableLanguages(this.request.getAcceptableLanguages());
        context.setPathInfo(this.request.getPathInfo());
        context.setServiceFactory(this.serviceFactory);
        context.setParameter("~httpRequestObject", this.httpRequest);
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(context, this.request.getQueryParameters(), this.request.getAcceptHeaders());
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse((Exception)messageException);
        return RestUtil.convertResponse(response);
    }

    private Response returnNoServiceResponse(MessageReference messageReference) {
        return this.returnException((ODataMessageException)new ODataInternalServerErrorException(messageReference));
    }

    @OPTIONS
    public Response handleOptions() {
        return this.returnNotImplementedResponse(ODataNotImplementedException.COMMON);
    }

    @HEAD
    public Response handleHead() throws ODataException {
        return this.handleGet();
    }

    private Response handle(ODataHttpMethod method) throws ODataException {
        this.request = ODataRequest.fromRequest((ODataRequest)this.request).method(method).build();
        ODataContextImpl context = new ODataContextImpl(this.request, this.serviceFactory);
        context.setParameter("~httpRequestObject", this.httpRequest);
        ODataService service = this.serviceFactory.createService((ODataContext)context);
        if (service == null) {
            return this.returnNoServiceResponse(ODataInternalServerErrorException.NOSERVICE);
        }
        service.getProcessor().setContext((ODataContext)context);
        context.setService(service);
        ODataRequestHandler requestHandler = new ODataRequestHandler(this.serviceFactory, service, context);
        ODataResponse odataResponse = requestHandler.handle(this.request);
        return RestUtil.convertResponse(odataResponse);
    }

    public static ODataSubLocator create(SubLocatorParameter param) throws ODataException {
        ODataSubLocator subLocator = new ODataSubLocator();
        subLocator.serviceFactory = param.getServiceFactory();
        subLocator.request = ODataRequest.acceptableLanguages((List)param.getHttpHeaders().getAcceptableLanguages()).httpMethod(param.getServletRequest().getMethod()).acceptHeaders(RestUtil.extractAcceptHeaders(param)).body(RestUtil.contentAsStream(RestUtil.extractRequestContent(param))).pathInfo((PathInfo)RestUtil.buildODataPathInfo(param)).allQueryParameters((Map)param.getUriInfo().getQueryParameters()).requestHeaders((Map)param.getHttpHeaders().getRequestHeaders()).contentType(RestUtil.extractRequestContentType(param).toContentTypeString()).build();
        subLocator.httpRequest = param.getServletRequest();
        return subLocator;
    }

    private ODataSubLocator() {
    }
}

