/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.net.URI;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.commons.api.http.HttpMethod;

public class BasicAuthHttpClientFactory
extends DefaultHttpClientFactory {
    private final String username;
    private final String password;

    public BasicAuthHttpClientFactory(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public DefaultHttpClient create(HttpMethod method, URI uri) {
        DefaultHttpClient httpclient = super.create(method, uri);
        httpclient.getCredentialsProvider().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return httpclient;
    }
}

