/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.util.HashMap;
import java.util.Map;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.IfInstruction;
import serp.bytecode.Instruction;
import serp.bytecode.JumpInstruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.ReturnInstruction;

public class ClassConstantInstruction {
    private static final Class[] _params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClassConstantInstruction.class$("java.lang.String")) : class$java$lang$String};
    private static final Map _wrappers = new HashMap();
    private Instruction _ins = null;
    private Code _code = null;
    private BCClass _class = null;
    private boolean _invalid = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$NoClassDefFoundError;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$ClassNotFoundException;

    ClassConstantInstruction(BCClass bc, Code code, Instruction nop) {
        this._class = bc;
        this._code = code;
        this._ins = nop;
    }

    public Instruction setClass(String name) {
        name = this._class.getProject().getNameCache().getExternalForm(name, false);
        this.setClassName(name, ClassConstantInstruction.getWrapperClass(name));
        return this._ins;
    }

    public Instruction setClass(Class type) {
        return this.setClass(type.getName());
    }

    public Instruction setClass(BCClass type) {
        return this.setClass(type.getName());
    }

    private void setClassName(String name, Class wrapper) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        Instruction before = this._code.hasNext() ? this._code.next() : null;
        this._code.before(this._ins);
        this._code.next();
        if (wrapper != null) {
            this._code.getstatic().setField(wrapper, "TYPE", class$java$lang$Class == null ? (class$java$lang$Class = ClassConstantInstruction.class$("java.lang.Class")) : class$java$lang$Class);
        } else {
            this.setObject(name);
        }
        if (before != null) {
            this._code.before(before);
        } else {
            this._code.afterLast();
        }
        this._invalid = true;
    }

    private void setObject(String name) {
        BCField field = this.addClassField(name);
        BCMethod method = this.addClassLoadMethod();
        this._code.getstatic().setField(field);
        IfInstruction ifnull = this._code.ifnull();
        this._code.getstatic().setField(field);
        JumpInstruction go2 = this._code.go2();
        ifnull.setTarget(this._code.constant().setValue(name));
        this._code.invokestatic().setMethod(method);
        this._code.dup();
        this._code.putstatic().setField(field);
        go2.setTarget(this._code.nop());
    }

    private BCField addClassField(String name) {
        String fieldName = "class$L" + name.replace('.', '$').replace('[', '$').replace(';', '$');
        BCField field = this._class.getDeclaredField(fieldName);
        if (field == null) {
            field = this._class.declareField(fieldName, class$java$lang$Class == null ? (class$java$lang$Class = ClassConstantInstruction.class$("java.lang.Class")) : class$java$lang$Class);
            field.makePackage();
            field.setStatic(true);
            field.setSynthetic(true);
        }
        return field;
    }

    private BCMethod addClassLoadMethod() {
        BCMethod method = this._class.getDeclaredMethod("class$", _params);
        if (method != null) {
            return method;
        }
        method = this._class.declareMethod("class$", class$java$lang$Class == null ? (class$java$lang$Class = ClassConstantInstruction.class$("java.lang.Class")) : class$java$lang$Class, _params);
        method.setStatic(true);
        method.makePackage();
        method.setSynthetic(true);
        Code code = method.getCode(true);
        code.setMaxStack(3);
        code.setMaxLocals(2);
        LocalVariableInstruction tryStart = code.aload().setLocal(0);
        code.invokestatic().setMethod(class$java$lang$Class == null ? (class$java$lang$Class = ClassConstantInstruction.class$("java.lang.Class")) : class$java$lang$Class, "forName", class$java$lang$Class == null ? (class$java$lang$Class = ClassConstantInstruction.class$("java.lang.Class")) : class$java$lang$Class, _params);
        ReturnInstruction tryEnd = code.areturn();
        LocalVariableInstruction handlerStart = code.astore().setLocal(1);
        code.anew().setType(class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = ClassConstantInstruction.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError);
        code.dup();
        code.aload().setLocal(1);
        code.invokevirtual().setMethod(class$java$lang$Throwable == null ? (class$java$lang$Throwable = ClassConstantInstruction.class$("java.lang.Throwable")) : class$java$lang$Throwable, "getMessage", class$java$lang$String == null ? (class$java$lang$String = ClassConstantInstruction.class$("java.lang.String")) : class$java$lang$String, null);
        code.invokespecial().setMethod(class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = ClassConstantInstruction.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError, "<init>", Void.TYPE, _params);
        code.athrow();
        code.addExceptionHandler((Instruction)tryStart, (Instruction)tryEnd, (Instruction)handlerStart, class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = ClassConstantInstruction.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException);
        return method;
    }

    private static Class getWrapperClass(String name) {
        if (name == null) {
            return null;
        }
        return (Class)_wrappers.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _wrappers.put(Byte.TYPE.getName(), class$java$lang$Byte == null ? (class$java$lang$Byte = ClassConstantInstruction.class$("java.lang.Byte")) : class$java$lang$Byte);
        _wrappers.put(Boolean.TYPE.getName(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassConstantInstruction.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        _wrappers.put(Character.TYPE.getName(), class$java$lang$Character == null ? (class$java$lang$Character = ClassConstantInstruction.class$("java.lang.Character")) : class$java$lang$Character);
        _wrappers.put(Double.TYPE.getName(), class$java$lang$Double == null ? (class$java$lang$Double = ClassConstantInstruction.class$("java.lang.Double")) : class$java$lang$Double);
        _wrappers.put(Float.TYPE.getName(), class$java$lang$Float == null ? (class$java$lang$Float = ClassConstantInstruction.class$("java.lang.Float")) : class$java$lang$Float);
        _wrappers.put(Integer.TYPE.getName(), class$java$lang$Integer == null ? (class$java$lang$Integer = ClassConstantInstruction.class$("java.lang.Integer")) : class$java$lang$Integer);
        _wrappers.put(Long.TYPE.getName(), class$java$lang$Long == null ? (class$java$lang$Long = ClassConstantInstruction.class$("java.lang.Long")) : class$java$lang$Long);
        _wrappers.put(Short.TYPE.getName(), class$java$lang$Short == null ? (class$java$lang$Short = ClassConstantInstruction.class$("java.lang.Short")) : class$java$lang$Short);
    }
}

