/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.cache;

import com.github.caldav4j.CalDAVResource;
import com.github.caldav4j.cache.CalDAVResourceCache;
import com.github.caldav4j.exceptions.CacheException;
import com.github.caldav4j.util.ICalendarUtils;
import com.github.caldav4j.util.UrlUtils;
import java.io.Serializable;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.component.VEvent;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;

public class EhCacheResourceCache
implements CalDAVResourceCache {
    private Cache uidToHrefCache = null;
    private Cache hrefToResourceCache = null;
    private static final String HREF_TO_RESOURCE_CACHE = "hrefToResourceCache";
    private static final String UID_TO_HREF_CACHE = "uidToHrefCache";
    private static EhCacheResourceCache cache = null;

    private EhCacheResourceCache() {
    }

    public static EhCacheResourceCache getCacheInstance() throws CacheException {
        if (cache == null) {
            cache = EhCacheResourceCache.createSimpleCache();
        }
        return cache;
    }

    public static void destroyCacheInstance() {
        cache = null;
    }

    public static EhCacheResourceCache createSimpleCache() throws CacheException {
        CacheManager cacheManager = CacheManager.create();
        EhCacheResourceCache myCache = new EhCacheResourceCache();
        Cache uidToHrefCache = new Cache(UID_TO_HREF_CACHE, 1000, null, false, System.getProperty("java.io.tmpdir"), false, 600L, 300L, false, 0L, null);
        Cache hrefToResourceCache = new Cache(HREF_TO_RESOURCE_CACHE, 1000, null, false, System.getProperty("java.io.tmpdir"), false, 600L, 300L, false, 0L, null);
        myCache.setHrefToResourceCache(hrefToResourceCache);
        myCache.setUidToHrefCache(uidToHrefCache);
        try {
            cacheManager.addCache(uidToHrefCache);
            cacheManager.addCache(hrefToResourceCache);
        }
        catch (ObjectExistsException e) {
            throw new CacheException("Cache exists", e);
        }
        return myCache;
    }

    public static void removeSimpleCache() {
        CacheManager cacheManager = CacheManager.create();
        cacheManager.removeCache(UID_TO_HREF_CACHE);
        cacheManager.removeCache(HREF_TO_RESOURCE_CACHE);
        cacheManager.shutdown();
    }

    public Cache getHrefToResourceCache() {
        return this.hrefToResourceCache;
    }

    public void setHrefToResourceCache(Cache pathToResourceCache) {
        this.hrefToResourceCache = pathToResourceCache;
    }

    public Cache getUidToHrefCache() {
        return this.uidToHrefCache;
    }

    public void setUidToHrefCache(Cache uidToPathCache) {
        this.uidToHrefCache = uidToPathCache;
    }

    @Override
    public synchronized String getHrefForEventUID(String uid) throws CacheException {
        Element e = null;
        try {
            e = this.uidToHrefCache.get((Serializable)((Object)uid));
        }
        catch (net.sf.ehcache.CacheException ce) {
            throw new CacheException("Problem with the uidToHrefCache", ce);
        }
        return e == null ? null : (String)e.getObjectValue();
    }

    @Override
    public synchronized CalDAVResource getResource(String href) throws CacheException {
        Element e = null;
        try {
            href = UrlUtils.removeDoubleSlashes(href);
            e = this.hrefToResourceCache.get((Serializable)((Object)href));
            if (e == null) {
                e = this.hrefToResourceCache.get((Serializable)((Object)UrlUtils.stripHost(href)));
            }
        }
        catch (net.sf.ehcache.CacheException ce) {
            throw new CacheException("Problem with the hrefToResourceCache", ce);
        }
        return e == null ? null : (CalDAVResource)e.getObjectValue();
    }

    @Override
    public synchronized void putResource(CalDAVResource calDAVResource) {
        String href = calDAVResource.getResourceMetadata().getHref();
        Element resourceElement = new Element((Serializable)((Object)href), (Serializable)calDAVResource);
        this.hrefToResourceCache.put(resourceElement);
        String uid = this.getEventUID(calDAVResource);
        if (uid != null) {
            Element hrefElement = new Element((Serializable)((Object)uid), (Serializable)((Object)href));
            this.uidToHrefCache.put(hrefElement);
        }
    }

    @Override
    public synchronized void removeResource(String href) throws CacheException {
        CalDAVResource resource = this.getResource(href);
        if (resource != null) {
            this.hrefToResourceCache.remove((Serializable)((Object)href));
            String uid = this.getEventUID(resource);
            if (uid != null) {
                this.uidToHrefCache.remove((Serializable)((Object)uid));
            }
        }
    }

    private synchronized String getEventUID(CalDAVResource calDAVResource) {
        Calendar calendar = calDAVResource.getCalendar();
        VEvent vevent = ICalendarUtils.getFirstEvent(calendar);
        if (vevent != null) {
            return ICalendarUtils.getUIDValue((Component)vevent);
        }
        return null;
    }
}

