/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.methods;

import com.github.caldav4j.methods.HttpAclMethod;
import com.github.caldav4j.methods.HttpCalDAVReportMethod;
import com.github.caldav4j.methods.HttpDeleteMethod;
import com.github.caldav4j.methods.HttpGetMethod;
import com.github.caldav4j.methods.HttpMkCalendarMethod;
import com.github.caldav4j.methods.HttpPostMethod;
import com.github.caldav4j.methods.HttpPropFindMethod;
import com.github.caldav4j.methods.HttpPutMethod;
import com.github.caldav4j.model.request.CalDAVReportRequest;
import com.github.caldav4j.model.request.CalendarRequest;
import com.github.caldav4j.model.request.MkCalendar;
import java.io.IOException;
import java.net.URI;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.security.AclProperty;

public class CalDAV4JMethodFactory {
    private boolean validatingOutputter = false;
    private ThreadLocal<CalendarBuilder> calendarBuilderThreadLocal = new ThreadLocal();
    private CalendarOutputter calendarOutputter = null;

    public HttpPutMethod createPutMethod(URI uri, CalendarRequest calendarRequest) {
        return new HttpPutMethod(uri, calendarRequest, this.getCalendarOutputterInstance());
    }

    public HttpPutMethod createPutMethod(String uri, CalendarRequest calendarRequest) {
        return new HttpPutMethod(uri, calendarRequest, this.getCalendarOutputterInstance());
    }

    public HttpPostMethod createPostMethod(URI uri, CalendarRequest calendarRequest) {
        return new HttpPostMethod(uri, calendarRequest, this.getCalendarOutputterInstance());
    }

    public HttpPostMethod createPostMethod(String uri, CalendarRequest calendarRequest) {
        return new HttpPostMethod(uri, calendarRequest, this.getCalendarOutputterInstance());
    }

    public HttpMkCalendarMethod createMkCalendarMethod(URI uri) {
        return new HttpMkCalendarMethod(uri);
    }

    public HttpMkCalendarMethod createMkCalendarMethod(URI uri, String displayName, String description, String descriptionLanguage) throws IOException {
        return new HttpMkCalendarMethod(uri, displayName, description, descriptionLanguage);
    }

    public HttpMkCalendarMethod createMkCalendarMethod(URI uri, MkCalendar mkCalendar) throws IOException {
        return new HttpMkCalendarMethod(uri, mkCalendar);
    }

    public HttpMkCalendarMethod createMkCalendarMethod(URI uri, String displayName, String description) throws IOException {
        return new HttpMkCalendarMethod(uri, displayName, description);
    }

    public HttpMkCalendarMethod createMkCalendarMethod(String uri) {
        return new HttpMkCalendarMethod(uri);
    }

    public HttpMkCalendarMethod createMkCalendarMethod(String uri, String displayName, String description, String descriptionLanguage) throws IOException {
        return new HttpMkCalendarMethod(uri, displayName, description, descriptionLanguage);
    }

    public HttpMkCalendarMethod createMkCalendarMethod(String uri, MkCalendar mkCalendar) throws IOException {
        return new HttpMkCalendarMethod(uri, mkCalendar);
    }

    public HttpMkCalendarMethod createMkCalendarMethod(String uri, String displayName, String description) throws IOException {
        return new HttpMkCalendarMethod(uri, displayName, description);
    }

    public HttpPropFindMethod createPropFindMethod(URI uri, DavPropertyNameSet names, int depth) throws IOException {
        return new HttpPropFindMethod(uri, names, depth);
    }

    public HttpPropFindMethod createPropFindMethod(URI uri, int propfindtype, DavPropertyNameSet names, int depth) throws IOException {
        return new HttpPropFindMethod(uri, propfindtype, names, depth);
    }

    public HttpPropFindMethod createPropFindMethod(String uri, DavPropertyNameSet names, int depth) throws IOException {
        return new HttpPropFindMethod(uri, names, depth);
    }

    public HttpPropFindMethod createPropFindMethod(String uri, int propfindtype, DavPropertyNameSet names, int depth) throws IOException {
        return new HttpPropFindMethod(uri, propfindtype, names, depth);
    }

    public HttpCalDAVReportMethod createCalDAVReportMethod(URI uri, CalDAVReportRequest request) throws IOException {
        HttpCalDAVReportMethod m = new HttpCalDAVReportMethod(uri, request);
        m.setCalendarBuilder(this.getCalendarBuilderInstance());
        return m;
    }

    public HttpCalDAVReportMethod createCalDAVReportMethod(URI uri, CalDAVReportRequest request, int depth) throws IOException {
        HttpCalDAVReportMethod m = new HttpCalDAVReportMethod(uri, request, depth);
        m.setCalendarBuilder(this.getCalendarBuilderInstance());
        return m;
    }

    public HttpCalDAVReportMethod createCalDAVReportMethod(String uri, CalDAVReportRequest request) throws IOException {
        return this.createCalDAVReportMethod(URI.create(uri), request);
    }

    public HttpCalDAVReportMethod createCalDAVReportMethod(String uri, CalDAVReportRequest request, int depth) throws IOException {
        return this.createCalDAVReportMethod(URI.create(uri), request, depth);
    }

    public HttpGetMethod createGetMethod(URI uri) {
        return new HttpGetMethod(uri, this.getCalendarBuilderInstance());
    }

    public HttpGetMethod createGetMethod(String uri) {
        return new HttpGetMethod(uri, this.getCalendarBuilderInstance());
    }

    public HttpAclMethod createAclMethod(URI uri, AclProperty property) throws IOException {
        return new HttpAclMethod(uri, property);
    }

    public HttpAclMethod createAclMethod(String uri, AclProperty property) throws IOException {
        return new HttpAclMethod(uri, property);
    }

    public HttpDeleteMethod createDeleteMethod(String uri) {
        return new HttpDeleteMethod(uri);
    }

    public HttpDeleteMethod createDeleteMethod(URI uri) {
        return new HttpDeleteMethod(uri);
    }

    public HttpDeleteMethod createDeleteMethod(String uri, String etag) {
        return new HttpDeleteMethod(uri, etag);
    }

    public HttpDeleteMethod createDeleteMethod(URI uri, String etag) {
        return new HttpDeleteMethod(uri, etag);
    }

    public boolean isCalendarValidatingOutputter() {
        return this.validatingOutputter;
    }

    public void setCalendarValidatingOutputter(boolean validatingOutputter) {
        this.validatingOutputter = validatingOutputter;
    }

    protected synchronized CalendarOutputter getCalendarOutputterInstance() {
        if (this.calendarOutputter == null) {
            this.calendarOutputter = new CalendarOutputter(this.validatingOutputter);
        }
        return this.calendarOutputter;
    }

    private CalendarBuilder getCalendarBuilderInstance() {
        CalendarBuilder builder = this.calendarBuilderThreadLocal.get();
        if (builder == null) {
            builder = new CalendarBuilder();
            this.calendarBuilderThreadLocal.set(builder);
        }
        return builder;
    }
}

