/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDeployClassesCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

@Deprecated(since="5.4", forRemoval=true)
public class ClientUserCodeDeploymentService {
    private final ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig;
    private final ClassLoader configClassLoader;
    private final List<Map.Entry<String, byte[]>> classDefinitionList = new ArrayList<Map.Entry<String, byte[]>>();

    public ClientUserCodeDeploymentService(ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig, ClassLoader configClassLoader) {
        this.clientUserCodeDeploymentConfig = clientUserCodeDeploymentConfig;
        this.configClassLoader = configClassLoader != null ? configClassLoader : Thread.currentThread().getContextClassLoader();
    }

    public void start() throws IOException, ClassNotFoundException {
        if (!this.clientUserCodeDeploymentConfig.isEnabled()) {
            return;
        }
        this.loadClassesFromJars();
        this.loadClasses();
    }

    private void loadClasses() throws ClassNotFoundException {
        for (String className : this.clientUserCodeDeploymentConfig.getClassNames()) {
            String resource = ReflectionUtils.toClassResourceId(className);
            try {
                InputStream is = this.configClassLoader.getResourceAsStream(resource);
                try {
                    if (is == null) {
                        throw new ClassNotFoundException(resource);
                    }
                    byte[] bytes = is.readAllBytes();
                    this.classDefinitionList.add(new AbstractMap.SimpleEntry<String, byte[]>(className, bytes));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                EmptyStatement.ignore(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesFromJars() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            for (String jarPath : this.clientUserCodeDeploymentConfig.getJarPaths()) {
                this.loadClassesFromJar(os, jarPath);
            }
        }
        finally {
            IOUtil.closeResource(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesFromJar(ByteArrayOutputStream os, String jarPath) throws IOException {
        JarInputStream inputStream = null;
        try {
            JarEntry entry;
            inputStream = this.getJarInputStream(jarPath);
            while ((entry = inputStream.getNextJarEntry()) != null) {
                String className = ClassLoaderUtil.extractClassName(entry.getName());
                if (className == null) continue;
                byte[] classDefinition = this.readClassDefinition(inputStream, os);
                inputStream.closeEntry();
                this.classDefinitionList.add(new AbstractMap.SimpleEntry<String, byte[]>(className, classDefinition));
            }
        }
        finally {
            IOUtil.closeResource(inputStream);
        }
    }

    private JarInputStream getJarInputStream(String jarPath) throws IOException {
        File file = new File(jarPath);
        if (file.exists()) {
            return new JarInputStream(new FileInputStream(file));
        }
        try {
            URL url = URI.create(jarPath).toURL();
            return new JarInputStream(url.openStream());
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            EmptyStatement.ignore(e);
            InputStream inputStream = this.configClassLoader.getResourceAsStream(jarPath);
            if (inputStream == null) {
                throw new FileNotFoundException("File could not be found in " + jarPath + "  and resources/" + jarPath);
            }
            return new JarInputStream(inputStream);
        }
    }

    private byte[] readClassDefinition(JarInputStream inputStream, ByteArrayOutputStream os) throws IOException {
        int v;
        os.reset();
        while ((v = inputStream.read()) != -1) {
            os.write(v);
        }
        return os.toByteArray();
    }

    public void deploy(HazelcastClientInstanceImpl client) throws ExecutionException, InterruptedException {
        if (!this.clientUserCodeDeploymentConfig.isEnabled() || this.classDefinitionList.isEmpty()) {
            return;
        }
        ClientMessage request = ClientDeployClassesCodec.encodeRequest(this.classDefinitionList);
        ClientInvocation invocation = new ClientInvocation(client, request, null);
        ClientInvocationFuture future = invocation.invokeUrgent();
        future.get();
    }

    public List<Map.Entry<String, byte[]>> getClassDefinitionList() {
        return this.classDefinitionList;
    }
}

