/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl.jdbcproperties;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class HikariTranslator {
    private static final String HIKARI_PREFIX = "hikari.";
    private static final Map<String, String> PROPERTY_MAP = new HashMap<String, String>();
    private final AtomicInteger poolCounter;
    private final String name;

    public HikariTranslator(AtomicInteger poolCounter, String name) {
        this.poolCounter = poolCounter;
        this.name = name;
    }

    public Properties translate(Properties source) {
        Properties hikariProperties = new Properties();
        source.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String keyString = (String)key;
            if (PROPERTY_MAP.containsKey(keyString)) {
                hikariProperties.put(keyString, value);
            } else if (keyString.startsWith(HIKARI_PREFIX)) {
                String keyNoPrefix = keyString.substring(HIKARI_PREFIX.length());
                hikariProperties.put(keyNoPrefix, source.get(keyString));
            } else {
                hikariProperties.put("dataSource." + keyString, value);
            }
        }));
        int cnt = this.poolCounter.getAndIncrement();
        hikariProperties.put("poolName", "HikariPool-" + cnt + "-" + this.name);
        return hikariProperties;
    }

    static {
        PROPERTY_MAP.put("jdbcUrl", "jdbcUrl");
        PROPERTY_MAP.put("connectionTimeout", "connectionTimeout");
        PROPERTY_MAP.put("idleTimeout", "idleTimeout");
        PROPERTY_MAP.put("keepaliveTime", "keepaliveTime");
        PROPERTY_MAP.put("maxLifetime", "maxLifetime");
        PROPERTY_MAP.put("minimumIdle", "minimumIdle");
        PROPERTY_MAP.put("maximumPoolSize", "maximumPoolSize");
    }
}

