/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.MapConfigReadOnly;
import com.hazelcast.internal.management.operation.AbstractManagementOperation;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;

public class UpdateMapConfigOperation
extends AbstractManagementOperation
implements Versioned {
    private boolean readBackupData;
    private int timeToLiveSeconds;
    private int maxIdleSeconds;
    private int maxSize;
    private int maxSizePolicyId;
    private int evictionPolicyId;
    private WanReplicationRef wanReplicationRef;
    private String mapName;
    private transient boolean applyWanReplicationRef;

    public UpdateMapConfigOperation() {
    }

    public UpdateMapConfigOperation(String mapName, int timeToLiveSeconds, int maxIdleSeconds, int maxSize, int maxSizePolicyId, boolean readBackupData, int evictionPolicyId, boolean applyWanReplicationRef, WanReplicationRef wanReplicationRef) {
        this.mapName = mapName;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.maxIdleSeconds = maxIdleSeconds;
        this.maxSize = maxSize;
        this.maxSizePolicyId = maxSizePolicyId;
        this.readBackupData = readBackupData;
        this.evictionPolicyId = evictionPolicyId;
        this.applyWanReplicationRef = applyWanReplicationRef;
        this.wanReplicationRef = wanReplicationRef;
    }

    @Override
    public void run() throws Exception {
        MapService service = (MapService)this.getService();
        MapConfig oldConfig = service.getMapServiceContext().getMapContainer(this.mapName).getMapConfig();
        MapConfig newConfig = new MapConfig(oldConfig);
        newConfig.setTimeToLiveSeconds(this.timeToLiveSeconds);
        newConfig.setMaxIdleSeconds(this.maxIdleSeconds);
        newConfig.setReadBackupData(this.readBackupData);
        if (this.applyWanReplicationRef) {
            newConfig.setWanReplicationRef(this.wanReplicationRef);
        }
        EvictionConfig evictionConfig = newConfig.getEvictionConfig();
        evictionConfig.setEvictionPolicy(EvictionPolicy.getById(this.evictionPolicyId));
        evictionConfig.setMaxSizePolicy(MaxSizePolicy.getById(this.maxSizePolicyId));
        evictionConfig.setSize(this.maxSize);
        MapContainer mapContainer = service.getMapServiceContext().getMapContainer(this.mapName);
        try {
            MapConfigReadOnly readOnlyConfig = new MapConfigReadOnly(newConfig);
            this.applyMapConfig(mapContainer, readOnlyConfig);
        }
        catch (Exception ex) {
            this.applyMapConfig(mapContainer, oldConfig);
            throw new InvalidConfigurationException("Applying the MapConfig failed: " + ex.getMessage(), ex);
        }
    }

    private void applyMapConfig(MapContainer mapContainer, MapConfig config) {
        mapContainer.setMapConfig(config);
        mapContainer.initEvictor();
        if (this.applyWanReplicationRef) {
            mapContainer.getWanContext().setMapConfig(config);
            mapContainer.getWanContext().start();
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxIdleSeconds);
        out.writeInt(this.maxSize);
        out.writeInt(this.maxSizePolicyId);
        out.writeBoolean(this.readBackupData);
        out.writeInt(this.evictionPolicyId);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            out.writeObject(this.wanReplicationRef);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.timeToLiveSeconds = in.readInt();
        this.maxIdleSeconds = in.readInt();
        this.maxSize = in.readInt();
        this.maxSizePolicyId = in.readInt();
        this.readBackupData = in.readBoolean();
        this.evictionPolicyId = in.readInt();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            this.wanReplicationRef = (WanReplicationRef)in.readObject();
            this.applyWanReplicationRef = true;
        } else {
            this.wanReplicationRef = null;
            this.applyWanReplicationRef = false;
        }
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

