/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.tcp.ProtocolException;
import com.hazelcast.internal.server.tcp.SingleProtocolEncoder;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class SingleProtocolDecoder
extends InboundHandler<ByteBuffer, Void> {
    protected final InboundHandler[] inboundHandlers;
    protected final ProtocolType supportedProtocol;
    protected volatile boolean verifyProtocolCalled;
    final SingleProtocolEncoder encoder;

    public SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler next, SingleProtocolEncoder encoder) {
        this(supportedProtocol, new InboundHandler[]{next}, encoder);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler[] next, SingleProtocolEncoder encoder) {
        this.supportedProtocol = supportedProtocol;
        this.inboundHandlers = next;
        this.encoder = encoder;
        this.verifyProtocolCalled = false;
    }

    @Override
    public void handlerAdded() {
        this.initSrcBuffer(3);
    }

    @Override
    public HandlerStatus onRead() {
        ((ByteBuffer)this.src).flip();
        try {
            if (((ByteBuffer)this.src).remaining() < 3) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            boolean verifyProtocolPreviouslyCalled = this.verifyProtocolCalled;
            if (verifyProtocolPreviouslyCalled || !this.verifyProtocol(this.loadProtocol())) {
                if (verifyProtocolPreviouslyCalled) {
                    ((ByteBuffer)this.src).position(((ByteBuffer)this.src).limit());
                }
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            this.encoder.signalProtocolVerified();
            this.initConnection();
            this.setupNextDecoder();
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }

    protected void setupNextDecoder() {
        this.channel.inboundPipeline().replace(this, this.inboundHandlers);
    }

    protected boolean verifyProtocol(String incomingProtocol) {
        this.verifyProtocolCalled = true;
        if (!incomingProtocol.equals(this.supportedProtocol.getDescriptor())) {
            this.handleUnexpectedProtocol(incomingProtocol);
            this.encoder.signalWrongProtocol("Unsupported protocol exchange detected, expected protocol: " + this.supportedProtocol.name() + ", actual protocol or first three bytes are: " + incomingProtocol);
            return false;
        }
        return true;
    }

    protected void handleUnexpectedProtocol(String incomingProtocol) {
        if (incomingProtocol.equals("HZX")) {
            throw new ProtocolException("Instance to be connected replied with HZX. This means a different protocol than expected sent to target instance");
        }
    }

    private String loadProtocol() {
        byte[] protocolBytes = new byte[3];
        ((ByteBuffer)this.src).get(protocolBytes);
        return new String(protocolBytes, StandardCharsets.UTF_8);
    }

    private void initConnection() {
        if (this.supportedProtocol == ProtocolType.MEMBER) {
            TcpServerConnection connection = (TcpServerConnection)this.channel.attributeMap().get(ServerConnection.class);
            connection.setConnectionType("MEMBER");
        }
    }
}

