/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.usercodedeployment;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.usercodedeployment.impl.ClassData;
import com.hazelcast.internal.usercodedeployment.impl.ClassDataProvider;
import com.hazelcast.internal.usercodedeployment.impl.ClassLocator;
import com.hazelcast.internal.usercodedeployment.impl.ClassSource;
import com.hazelcast.internal.usercodedeployment.impl.filter.ClassNameFilterParser;
import com.hazelcast.internal.usercodedeployment.impl.filter.MemberProviderFilterParser;
import com.hazelcast.internal.util.filter.Filter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated(since="5.4", forRemoval=true)
public final class UserCodeDeploymentService
implements ManagedService {
    public static final String SERVICE_NAME = "user-code-deployment-service";
    private volatile boolean enabled;
    private ClassDataProvider provider;
    private ClassLocator locator;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        UserCodeDeploymentConfig config = nodeEngine.getConfig().getUserCodeDeploymentConfig();
        if (!config.isEnabled()) {
            return;
        }
        ClassLoader parent = nodeEngine.getConfigClassLoader().getParent();
        Filter<String> classNameFilter = ClassNameFilterParser.parseClassNameFilters(config);
        Filter<Member> memberFilter = MemberProviderFilterParser.parseMemberFilter(config.getProviderFilter());
        ConcurrentHashMap<String, ClassSource> classMap = new ConcurrentHashMap<String, ClassSource>();
        ConcurrentHashMap<String, ClassSource> clientClassMap = new ConcurrentHashMap<String, ClassSource>();
        UserCodeDeploymentConfig.ProviderMode providerMode = config.getProviderMode();
        ILogger providerLogger = nodeEngine.getLogger(ClassDataProvider.class);
        this.provider = new ClassDataProvider(providerMode, parent, classMap, clientClassMap, providerLogger);
        UserCodeDeploymentConfig.ClassCacheMode classCacheMode = config.getClassCacheMode();
        this.locator = new ClassLocator(classMap, clientClassMap, parent, classNameFilter, memberFilter, classCacheMode, nodeEngine);
        this.enabled = config.isEnabled();
    }

    public void defineClasses(List<Map.Entry<String, byte[]>> classDefinitions) {
        if (!this.enabled) {
            throw new IllegalStateException("User Code Deployment is not enabled. To enable User Code Deployment, do one of the following:\n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.getUserCodeDeploymentConfig().setEnabled(true);", "hazelcast.user-code-deployment.enabled to true", "-Dhz.user-code-deployment.enabled=true", "HZ_USERCODEDEPLOYMENT_ENABLED=true"));
        }
        this.locator.defineClassesFromClient(classDefinitions);
    }

    public ClassData getClassDataOrNull(String className) {
        if (!this.enabled) {
            return null;
        }
        return this.provider.getClassDataOrNull(className);
    }

    public Class<?> handleClassNotFoundException(String name) throws ClassNotFoundException {
        if (!this.enabled) {
            throw new ClassNotFoundException("User Code Deployment is not enabled. Cannot find class " + name);
        }
        return this.locator.handleClassNotFoundException(name);
    }

    public Class<?> findLoadedClass(String name) {
        if (!this.enabled) {
            return null;
        }
        return this.locator.findLoadedClass(name);
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
    }
}

