/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.impl.AutoCloseableTraversers;
import com.hazelcast.jet.impl.util.AutoCloseableTraverser;
import java.util.function.Function;

public class FlatMappingAutoCloseableTraverser<T, R>
implements AutoCloseableTraverser<R> {
    private static final AutoCloseableTraverser NULL_TRAVERSER = new AutoCloseableTraverser(){

        @Override
        public Object next() {
            return null;
        }
    };
    private final Traverser<T> wrapped;
    private final Function<? super T, ? extends AutoCloseableTraverser<? extends R>> mapper;
    private AutoCloseableTraverser<? extends R> currentTraverser = AutoCloseableTraversers.emptyAutoCloseableTraverser();

    public FlatMappingAutoCloseableTraverser(Traverser<T> wrapped, Function<? super T, ? extends AutoCloseableTraverser<? extends R>> mapper) {
        this.wrapped = wrapped;
        this.mapper = mapper;
    }

    @Override
    public R next() {
        do {
            Object r;
            if ((r = this.currentTraverser.next()) != null) {
                return (R)r;
            }
            this.currentTraverser = this.nextTraverser();
        } while (this.currentTraverser != NULL_TRAVERSER);
        return null;
    }

    private AutoCloseableTraverser<? extends R> nextTraverser() {
        T t = this.wrapped.next();
        return t != null ? this.mapper.apply(t) : NULL_TRAVERSER;
    }

    @Override
    public void close() throws Exception {
        if (this.currentTraverser != NULL_TRAVERSER) {
            this.currentTraverser.close();
        }
    }
}

