/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging.impl;

import com.hazelcast.auditlog.AuditlogService;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.logging.impl.InternalLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoggingServiceImpl
implements LoggingService {
    private final CopyOnWriteArrayList<LogListenerRegistration> listeners = new CopyOnWriteArrayList();
    private final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    private final ConstructorFunction<String, ILogger> loggerConstructor = x$0 -> new DefaultLogger((String)x$0);
    private final LoggerFactory loggerFactory;
    private final boolean detailsEnabled;
    private final boolean shutdownLoggingOnHazelcastShutdown;
    private final Node node;
    private final String versionMessage;
    private volatile MemberImpl thisMember = new MemberImpl();
    private volatile String thisAddressString = "[LOCAL] ";
    private volatile Level minLevel = Level.OFF;
    private volatile Level levelSet;

    public LoggingServiceImpl(String clusterName, String loggingType, BuildInfo buildInfo, boolean detailsEnabled, boolean shutdownLoggingOnHazelcastShutdown, Node node) {
        this.loggerFactory = Logger.newLoggerFactory(loggingType);
        this.detailsEnabled = detailsEnabled;
        this.node = node;
        this.versionMessage = "[" + clusterName + "] [" + buildInfo.getVersion() + "] ";
        this.shutdownLoggingOnHazelcastShutdown = shutdownLoggingOnHazelcastShutdown;
    }

    public void setThisMember(MemberImpl thisMember) {
        this.thisMember = thisMember;
        this.thisAddressString = "[" + thisMember.getAddress().getHost() + "]:" + thisMember.getAddress().getPort() + " ";
    }

    @Nullable
    public Level getLevel() {
        return this.levelSet;
    }

    public void setLevel(@Nonnull Level level) {
        LoggerFactory loggerFactory = this.loggerFactory;
        if (!(loggerFactory instanceof InternalLoggerFactory)) {
            throw new HazelcastException("Logger factory doesn't support dynamic log level changes: " + this.loggerFactory.getClass());
        }
        InternalLoggerFactory factory = (InternalLoggerFactory)((Object)loggerFactory);
        this.levelSet = level;
        factory.setLevel(level);
        AuditlogService auditlogService = this.node.getNodeExtension().getAuditlogService();
        auditlogService.eventBuilder("HZ-0701").message("Log level set.").addParameter("level", level).log();
    }

    public void setLevel(@Nonnull String level) {
        Level parsedLevel;
        try {
            parsedLevel = Level.parse(StringUtil.upperCaseInternal(level));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid level '" + level + "', known levels are: " + String.join((CharSequence)", ", Level.OFF.getName(), Level.SEVERE.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()), e);
        }
        this.setLevel(parsedLevel);
    }

    public void resetLevel() {
        LoggerFactory loggerFactory = this.loggerFactory;
        if (loggerFactory instanceof InternalLoggerFactory) {
            InternalLoggerFactory factory = (InternalLoggerFactory)((Object)loggerFactory);
            if (this.levelSet != null) {
                factory.resetLevel();
                this.levelSet = null;
                AuditlogService auditlogService = this.node.getNodeExtension().getAuditlogService();
                auditlogService.eventBuilder("HZ-0702").message("Log level reset.").log();
            }
        } else {
            throw new HazelcastException("Logger factory doesn't support dynamic log level changes: " + this.loggerFactory.getClass());
        }
    }

    @Override
    @Nonnull
    public ILogger getLogger(@Nonnull String name) {
        Preconditions.checkNotNull(name, "name must not be null");
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, name, this.loggerConstructor);
    }

    @Override
    @Nonnull
    public ILogger getLogger(@Nonnull Class<?> clazz) {
        Preconditions.checkNotNull(clazz, "class must not be null");
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, clazz.getName(), this.loggerConstructor);
    }

    @Override
    public void addLogListener(@Nonnull Level level, @Nonnull LogListener logListener) {
        this.listeners.add(new LogListenerRegistration(level, logListener));
        if (level.intValue() < this.minLevel.intValue()) {
            this.minLevel = level;
        }
    }

    @Override
    public void removeLogListener(@Nonnull LogListener logListener) {
        this.listeners.remove(new LogListenerRegistration(Level.ALL, logListener));
    }

    @Override
    public void shutdown() {
        LoggerFactory loggerFactory;
        if (this.shutdownLoggingOnHazelcastShutdown && (loggerFactory = this.loggerFactory) instanceof InternalLoggerFactory) {
            InternalLoggerFactory factory = (InternalLoggerFactory)((Object)loggerFactory);
            factory.shutdown();
        }
    }

    void handleLogEvent(LogEvent logEvent) {
        for (LogListenerRegistration logListenerRegistration : this.listeners) {
            if (logEvent.getLogRecord().getLevel().intValue() < logListenerRegistration.getLevel().intValue()) continue;
            logListenerRegistration.getLogListener().log(logEvent);
        }
    }

    private static class LogListenerRegistration {
        final Level level;
        final LogListener logListener;

        LogListenerRegistration(@Nonnull Level level, @Nonnull LogListener logListener) {
            Preconditions.checkNotNull(level, "level must not be null");
            Preconditions.checkNotNull(logListener, "logListener must not be null");
            this.level = level;
            this.logListener = logListener;
        }

        public Level getLevel() {
            return this.level;
        }

        public LogListener getLogListener() {
            return this.logListener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogListenerRegistration other = (LogListenerRegistration)obj;
            return !(this.logListener == null ? other.logListener != null : !this.logListener.equals(other.logListener));
        }

        public int hashCode() {
            return this.logListener != null ? this.logListener.hashCode() : 0;
        }
    }

    private class DefaultLogger
    extends AbstractLogger {
        final String name;
        final ILogger logger;

        DefaultLogger(String name) {
            this.name = name;
            this.logger = LoggingServiceImpl.this.loggerFactory.getLogger(name);
        }

        @Override
        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            boolean loggable = this.logger.isLoggable(level);
            if (loggable || level.intValue() >= LoggingServiceImpl.this.minLevel.intValue()) {
                if (LoggingServiceImpl.this.detailsEnabled) {
                    String address = LoggingServiceImpl.this.thisAddressString;
                    message = (address != null ? address : "") + LoggingServiceImpl.this.versionMessage + (String)message;
                }
                if (loggable) {
                    this.logger.log(level, (String)message, thrown);
                }
                if (!LoggingServiceImpl.this.listeners.isEmpty()) {
                    LogRecord logRecord = new LogRecord(level, (String)message);
                    logRecord.setThrown(thrown);
                    logRecord.setLoggerName(this.name);
                    logRecord.setSourceClassName(this.name);
                    LogEvent logEvent = new LogEvent(logRecord, LoggingServiceImpl.this.thisMember);
                    LoggingServiceImpl.this.handleLogEvent(logEvent);
                }
            }
        }

        @Override
        public void log(LogEvent logEvent) {
            LoggingServiceImpl.this.handleLogEvent(logEvent);
        }

        @Override
        public Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }
}

