/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.publisher;

import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.Registry;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class QueryCacheListenerRegistry
implements Registry<String, UUID> {
    private final ConstructorFunction<String, UUID> registryConstructorFunction = new ConstructorFunction<String, UUID>(){

        @Override
        public UUID createNew(String ignored) {
            Function<String, UUID> registration = QueryCacheListenerRegistry.this.context.getPublisherContext().getListenerRegistrator();
            return registration.apply(QueryCacheListenerRegistry.this.mapName);
        }
    };
    private final String mapName;
    private final QueryCacheContext context;
    private final ConcurrentMap<String, UUID> listeners;

    public QueryCacheListenerRegistry(QueryCacheContext context, String mapName) {
        this.context = context;
        this.mapName = mapName;
        this.listeners = new ConcurrentHashMap<String, UUID>();
    }

    @Override
    public UUID getOrCreate(String cacheId) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.listeners, cacheId, this.registryConstructorFunction);
    }

    @Override
    public UUID getOrNull(String cacheId) {
        return (UUID)this.listeners.get(cacheId);
    }

    @Override
    public Map<String, UUID> getAll() {
        return Collections.unmodifiableMap(this.listeners);
    }

    @Override
    public UUID remove(String cacheId) {
        return (UUID)this.listeners.remove(cacheId);
    }
}

