/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.operation.BasePutOperation;
import com.hazelcast.map.impl.operation.steps.TxnSetOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.StaticParams;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.tx.MapTxnOperation;
import com.hazelcast.map.impl.tx.TxnSetBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.UUID;

public class TxnSetOperation
extends BasePutOperation
implements MapTxnOperation,
MutatingOperation {
    private long ttl;
    private long version;
    private UUID ownerUuid;
    private UUID transactionId;
    private transient boolean shouldBackup;

    public TxnSetOperation() {
    }

    public TxnSetOperation(String name, Data dataKey, Data value, long version, long ttl) {
        super(name, dataKey, value);
        this.version = version;
        this.ttl = ttl;
    }

    @Override
    public boolean shouldWait() {
        return false;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        if (!this.recordStore.canAcquireLock(this.dataKey, this.ownerUuid, this.threadId)) {
            this.wbqCapacityCounter().decrement(this.transactionId);
            throw new TransactionException("Cannot acquire lock UUID: " + this.ownerUuid + ", threadId: " + this.threadId);
        }
    }

    @Override
    protected void runInternal() {
        this.recordStore.unlock(this.dataKey, this.ownerUuid, this.threadId, this.getCallId());
        Object record = this.recordStore.getRecordOrNull(this.dataKey, false);
        if (record == null || this.version == (long)record.getVersion()) {
            EventService eventService = this.getNodeEngine().getEventService();
            if (eventService.hasEventRegistration("hz:impl:mapService", this.getName())) {
                this.oldValue = record == null ? null : this.mapServiceContext.toData(record.getValue());
            }
            this.eventType = record == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
            this.recordStore.setTxn(this.dataKey, this.dataValue, this.ttl, -1L, this.transactionId);
            this.shouldBackup = true;
        }
    }

    @Override
    public State createState() {
        return super.createState().setStaticPutParams(this.getStaticParams()).setTxnId(this.transactionId).setOwnerUuid(this.ownerUuid).setVersion(this.version).setTtl(this.ttl);
    }

    @Override
    public Step getStartingStep() {
        return TxnSetOpSteps.READ;
    }

    @Override
    protected StaticParams getStaticParams() {
        return StaticParams.TXN_SET_PARAMS;
    }

    @Override
    public void applyState(State state) {
        super.applyState(state);
        this.shouldBackup = state.getEntryEventType() != null;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void setOwnerUuid(UUID ownerUuid) {
        this.ownerUuid = ownerUuid;
    }

    @Override
    public void setTransactionId(UUID transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(false);
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup && super.shouldBackup();
    }

    @Override
    public Operation getBackupOperation() {
        Object record = this.recordStore.getRecord(this.dataKey);
        this.dataValue = this.getValueOrPostProcessedValue((Record)record, this.dataValue);
        ExpiryMetadata expiryMetadata = this.recordStore.getExpirySystem().getExpiryMetadata(this.dataKey);
        return new TxnSetBackupOperation(this.name, this.dataKey, (Record<Data>)record, this.dataValue, expiryMetadata, this.transactionId);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.version);
        out.writeLong(this.ttl);
        UUIDSerializationUtil.writeUUID(out, this.ownerUuid);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.version = in.readLong();
        this.ttl = in.readLong();
        this.ownerUuid = UUIDSerializationUtil.readUUID(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 69;
    }
}

