/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor;

import com.hazelcast.internal.nio.Packet;
import com.hazelcast.map.impl.operation.steps.engine.StepAwareOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.Set;
import java.util.function.Consumer;

public abstract class OperationRunner {
    protected final int partitionId;
    protected volatile Object currentTask;
    private volatile Thread currentThread;

    public OperationRunner(int partitionId) {
        this.partitionId = partitionId;
    }

    public abstract long executedOperationsCount();

    public abstract void run(Packet var1) throws Exception;

    public abstract void run(Runnable var1);

    public abstract void run(Operation var1);

    public final Object currentTask() {
        return this.currentTask;
    }

    public final void setCurrentThread(Thread currentThread) {
        this.currentThread = currentThread;
    }

    public final Thread currentThread() {
        return this.currentThread;
    }

    public final int getPartitionId() {
        return this.partitionId;
    }

    public static void runDirect(Operation op) throws Exception {
        try {
            op.pushThreadContext();
            op.beforeRun();
            op.call();
            op.afterRun();
        }
        finally {
            op.popThreadContext();
            op.afterRunFinal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallStatus runDirect(Operation op, NodeEngineImpl nodeEngine, Set<Operation> asyncOperations, Consumer<Operation> backupOpAfterRun) throws Exception {
        CallStatus callStatus;
        try {
            op.pushThreadContext();
            op.beforeRun();
            callStatus = op.call();
            op.afterRun();
            if (callStatus.ordinal() == 3) {
                Offload offload = (Offload)callStatus;
                offload.init(nodeEngine, asyncOperations);
                if (op instanceof StepAwareOperation) {
                    StepAwareOperation stepAwareOperation = (StepAwareOperation)((Object)op);
                    if (op instanceof BackupOperation) {
                        stepAwareOperation.setBackupOpAfterRun(backupOpAfterRun);
                    }
                }
                offload.start();
            }
        }
        finally {
            op.popThreadContext();
            op.afterRunFinal();
        }
        return callStatus;
    }
}

